/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.producer;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.crawler.web.RecordProducer;
import org.eclipse.smila.importing.crawler.web.WebCrawlerException;
import org.eclipse.smila.taskworker.TaskLog;
import org.eclipse.smila.utils.digest.DigestHelper;

public class SimpleRecordProducer
implements RecordProducer {
    @Override
    public Collection<Record> produceRecords(Record record, AnyMap parameters, TaskLog log) throws WebCrawlerException {
        String url = record.getMetadata().getStringValue("http.url");
        String source = parameters.getStringValue("dataSource");
        record.setId(String.valueOf(source) + ":" + url);
        record.setSource(source);
        this.calculateDeltaHash(record);
        return Arrays.asList(record);
    }

    private void calculateDeltaHash(Record record) {
        Any contentLength;
        Any lastModified;
        AnyMap metadata = record.getMetadata();
        String deltaHash = null;
        deltaHash = record.hasAttachment("http.content") ? DigestHelper.calculateDigest((byte[])record.getAttachmentAsBytes("http.content")) : ((lastModified = (Any)metadata.get((Object)"http.lastModified")) != null ? lastModified.toString() : ((contentLength = (Any)metadata.get((Object)"http.size")) != null ? String.valueOf(contentLength.toString()) + "-" + metadata.get((Object)"http.contenttype") : UUID.randomUUID().toString()));
        if (deltaHash != null) {
            metadata.put("_deltaHash", deltaHash);
        }
    }
}

