/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.state.objectstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.importing.StateException;
import org.eclipse.smila.importing.StateNotFoundException;
import org.eclipse.smila.importing.state.objectstore.StateStoreConfiguration;
import org.eclipse.smila.objectstore.NoSuchObjectException;
import org.eclipse.smila.objectstore.NoSuchStoreException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.utils.digest.DigestHelper;

public class ObjectStoreStateService {
    protected static final String KEY = "key";
    protected static final String KEY_OBJECTID = "objectId";
    protected static final String KEY_SOURCEID = "sourceId";
    protected static final String KEY_DESCRIPTOR = "descriptor";
    protected static final String KEY_JOBRUNID = "jobRunId";
    protected static final String ROOT_ENTRIES = "entries/";
    private static final int LIMIT_COUNTENTRIES_EXACT = 10000;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final IpcAnyReader _parser = new IpcAnyReader();
    private final IpcAnyWriter _writer = new IpcAnyWriter();
    private final StateStoreConfiguration _configuration;
    private final ObjectStoreService _objectStore;
    private final String _storeName;

    public ObjectStoreStateService(String storeName, StateStoreConfiguration configuration, ObjectStoreService objectStore) {
        this._storeName = storeName;
        this._configuration = configuration;
        this._objectStore = objectStore;
    }

    public AnyMap getEntry(String sourceId, String objectId) throws StateException {
        String key = this.createDeltaKey(sourceId, objectId);
        return this.readEntry(key);
    }

    public void mark(String sourceId, String objectId, String jobRunId, String descriptor) throws StateException {
        String key = this.createDeltaKey(sourceId, objectId);
        AnyMap entry = this.createDeltaEntry(sourceId, objectId, jobRunId, descriptor);
        entry.put(KEY, key);
        this.writeEntry(entry);
    }

    public void clearSource(String sourceId) throws StateException {
        try {
            this._objectStore.removeObjects(this._storeName, this.createDeltaEntryBase(sourceId));
        }
        catch (NoSuchStoreException noSuchStoreException) {
        }
        catch (ObjectStoreException ex) {
            throw new StateException("Error removing all entries for source " + sourceId, (Throwable)ex);
        }
    }

    public void clearAll() throws StateException {
        try {
            this._objectStore.clearStore(this._storeName);
        }
        catch (NoSuchStoreException noSuchStoreException) {
        }
        catch (ObjectStoreException ex) {
            throw new StateException("Error clearing all entries of all sources", (Throwable)ex);
        }
    }

    public Collection<String> getSourceIds() throws StateException {
        try {
            ArrayList<String> sourceIds = new ArrayList<String>();
            try {
                Collection sourceEntries = this._objectStore.getPrefixes(this._storeName, ROOT_ENTRIES);
                for (String sourceEntry : sourceEntries) {
                    String sourceId = sourceEntry.substring(ROOT_ENTRIES.length());
                    if (sourceId.endsWith("/")) {
                        sourceId = sourceId.substring(0, sourceId.length() - 1);
                    }
                    sourceIds.add(sourceId);
                }
            }
            catch (NoSuchStoreException noSuchStoreException) {}
            return sourceIds;
        }
        catch (ObjectStoreException ex) {
            throw new StateException("Error determining existing sources.", (Throwable)ex);
        }
    }

    public long countEntries(String sourceId, boolean countExact) throws StateException {
        if (!this.hasSource(sourceId)) {
            throw new StateNotFoundException("Source '" + sourceId + "' doesn't exist in store '" + this._storeName + "'");
        }
        try {
            long entryCount = 0L;
            int shardCount = 0;
            String sourceBase = this.createDeltaEntryBase(sourceId);
            Collection shardIds = this._objectStore.getPrefixes(this._storeName, sourceBase);
            if (shardIds != null) {
                Iterator iterator = shardIds.iterator();
                while (iterator.hasNext()) {
                    String shardId;
                    String shardPrefix = shardId = (String)iterator.next();
                    if (!shardId.endsWith("/")) {
                        shardPrefix = String.valueOf(shardPrefix) + "/";
                    }
                    ++shardCount;
                    if (countExact || (entryCount += this._objectStore.countStoreObjects(this._storeName, shardPrefix)) <= 10000L) continue;
                    return entryCount * (long)shardIds.size() / (long)shardCount;
                }
            }
            return entryCount;
        }
        catch (ObjectStoreException ex) {
            throw new StateException("Error determining existing sources.", (Throwable)ex);
        }
    }

    private boolean hasSource(String sourceId) throws StateException {
        return this.getSourceIds().contains(sourceId);
    }

    private AnyMap readEntry(String key) throws StateException {
        byte[] data;
        try {
            data = this.readEntryIfExists(key);
        }
        catch (ObjectStoreException ex) {
            throw new StateException("Error reading object " + key + " from objectstore", (Throwable)ex);
        }
        if (data == null) {
            return null;
        }
        try {
            return (AnyMap)this._parser.readBinaryObject(data);
        }
        catch (IOException ex) {
            throw new StateException("Error parsing object " + key, (Throwable)ex);
        }
    }

    private byte[] readEntryIfExists(String key) throws ObjectStoreException {
        try {
            return ObjectStoreRetryUtil.retryGetObject((ObjectStoreService)this._objectStore, (String)this._storeName, (String)key);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return null;
        }
        catch (NoSuchStoreException noSuchStoreException) {
            return null;
        }
    }

    protected void writeEntry(AnyMap value) throws StateException {
        String key = value.getStringValue(KEY);
        byte[] data = null;
        try {
            data = this._writer.writeBinaryObject((Any)value);
        }
        catch (IOException ex) {
            throw new StateException("Error converting object " + value + " for " + key + " to BON", (Throwable)ex);
        }
        this.writeEntryEnsureStore(key, data);
    }

    private void writeEntryEnsureStore(String key, byte[] data) throws StateException {
        try {
            try {
                ObjectStoreRetryUtil.retryPutObject((ObjectStoreService)this._objectStore, (String)this._storeName, (String)key, (byte[])data);
            }
            catch (NoSuchStoreException noSuchStoreException) {
                this._log.info((Object)("Creating store '" + this._storeName + "'"));
                ObjectStoreRetryUtil.retryEnsureStore((ObjectStoreService)this._objectStore, (String)this._storeName);
                ObjectStoreRetryUtil.retryPutObject((ObjectStoreService)this._objectStore, (String)this._storeName, (String)key, (byte[])data);
            }
        }
        catch (ObjectStoreException ex) {
            throw new StateException("Error writing object for " + key + " to objectstore", (Throwable)ex);
        }
    }

    private String createDeltaKey(String sourceId, String objectId) {
        String idDigest = DigestHelper.calculateDigest((String)objectId);
        return String.valueOf(this.createDeltaEntryBase(sourceId)) + this._configuration.getEntryKey(idDigest);
    }

    private String createDeltaEntryBase(String sourceId) {
        return ROOT_ENTRIES + sourceId + '/';
    }

    private AnyMap createDeltaEntry(String sourceId, String objectId, String jobRunId, String descriptor) {
        AnyMap entry = DataFactory.DEFAULT.createAnyMap();
        entry.put(KEY_OBJECTID, objectId);
        entry.put(KEY_SOURCEID, sourceId);
        entry.put(KEY_DESCRIPTOR, descriptor);
        entry.put(KEY_JOBRUNID, jobRunId);
        return entry;
    }
}

