/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class CheckConstraintDescriptor
extends ConstraintDescriptor {
    private ReferencedColumns referencedColumns;
    private String constraintText;

    CheckConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, UUID constraintId, String constraintText, ReferencedColumns referencedColumns, SchemaDescriptor schemaDesc, boolean isEnabled) {
        super(dataDictionary, table, constraintName, deferrable, initiallyDeferred, null, constraintId, schemaDesc, isEnabled);
        this.constraintText = constraintText;
        this.referencedColumns = referencedColumns;
    }

    public boolean hasBackingIndex() {
        return false;
    }

    public int getConstraintType() {
        return 4;
    }

    public String getConstraintText() {
        return this.constraintText;
    }

    public UUID getConglomerateId() {
        return null;
    }

    public ReferencedColumns getReferencedColumnsDescriptor() {
        return this.referencedColumns;
    }

    public void setReferencedColumnsDescriptor(ReferencedColumns rcd) {
        this.referencedColumns = rcd;
    }

    public int[] getReferencedColumns() {
        return this.referencedColumns.getReferencedColumnPositions();
    }

    public boolean needsToFire(int stmtType, int[] modifiedCols) {
        if (!this.isEnabled) {
            return false;
        }
        if (stmtType == 1) {
            return true;
        }
        if (stmtType == 4) {
            return false;
        }
        return CheckConstraintDescriptor.doColumnsIntersect(modifiedCols, this.getReferencedColumns());
    }

    public String toString() {
        return "constraintText: " + this.constraintText + "\n" + "referencedColumns: " + this.referencedColumns + "\n" + super.toString();
    }
}

