/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedSavepoint30;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public class EmbedConnection30
extends EmbedConnection {
    public EmbedConnection30(InternalDriver driver, String url, Properties info) throws SQLException {
        super(driver, url, info);
    }

    public EmbedConnection30(EmbedConnection inputConnection) {
        super(inputConnection);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.commonSetSavepointCode(null, false);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.commonSetSavepointCode(name, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Savepoint commonSetSavepointCode(String name, boolean userSuppliedSavepointName) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                EmbedSavepoint30 savePt;
                this.verifySavepointCommandIsAllowed();
                if (userSuppliedSavepointName && name == null) {
                    throw this.newSQLException("XJ011.S");
                }
                if (userSuppliedSavepointName && name.length() > 128) {
                    throw this.newSQLException("42622", name, String.valueOf(128));
                }
                if (userSuppliedSavepointName && name.startsWith("SYS")) {
                    throw this.newSQLException("42939", "SYS");
                }
                EmbedSavepoint30 embedSavepoint30 = savePt = new EmbedSavepoint30(this, name);
                return embedSavepoint30;
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.verifySavepointCommandIsAllowed();
                this.verifySavepointArg(savepoint);
                this.getLanguageConnection().internalRollbackToSavepoint(((EmbedSavepoint30)savepoint).getInternalName(), true, savepoint);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.verifySavepointCommandIsAllowed();
                this.verifySavepointArg(savepoint);
                this.getLanguageConnection().releaseSavePoint(((EmbedSavepoint30)savepoint).getInternalName(), savepoint);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    private void verifySavepointCommandIsAllowed() throws SQLException {
        if (this.autoCommit) {
            throw this.newSQLException("XJ010.S");
        }
        StatementContext stmtCtxt = this.getLanguageConnection().getStatementContext();
        if (stmtCtxt != null && stmtCtxt.inTrigger()) {
            throw this.newSQLException("XJ017.S");
        }
    }

    private void verifySavepointArg(Savepoint savepoint) throws SQLException {
        EmbedSavepoint30 lsv = (EmbedSavepoint30)savepoint;
        if (lsv == null) {
            throw Util.generateCsSQLException("3B001.S", "null");
        }
        if (!lsv.sameConnection(this)) {
            throw this.newSQLException("3B502.S");
        }
    }
}

