/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.util.Properties;
import org.apache.derby.iapi.error.PassThroughException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.io.WritableStorageFactory;

public class UpdateServiceProperties
extends Properties {
    private PersistentService serviceType;
    private String serviceName;
    private volatile WritableStorageFactory storageFactory;
    private boolean serviceBooted;

    public UpdateServiceProperties(PersistentService serviceType, String serviceName, Properties actualSet, boolean serviceBooted) {
        super(actualSet);
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.serviceBooted = serviceBooted;
    }

    public void setServiceBooted() {
        this.serviceBooted = true;
    }

    public void setStorageFactory(WritableStorageFactory storageFactory) {
        this.storageFactory = storageFactory;
    }

    public WritableStorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    public Object put(Object key, Object value) {
        Object ref = this.defaults.put(key, value);
        if (!((String)key).startsWith("derby.__rt.")) {
            this.update();
        }
        return ref;
    }

    public Object remove(Object key) {
        Object ref = this.defaults.remove(key);
        if (ref != null && !((String)key).startsWith("derby.__rt.")) {
            this.update();
        }
        return ref;
    }

    public void saveServiceProperties() {
        SanityManager.ASSERT(this.storageFactory != null, "UpdateServiceProperties.saveServiceProperties() called before storageFactory set.");
        try {
            this.serviceType.saveServiceProperties(this.serviceName, this.storageFactory, BaseMonitor.removeRuntimeProperties(this.defaults), false);
        }
        catch (StandardException mse) {
            throw new PassThroughException(mse);
        }
    }

    private void update() {
        try {
            if (this.serviceBooted) {
                this.serviceType.saveServiceProperties(this.serviceName, this.storageFactory, BaseMonitor.removeRuntimeProperties(this.defaults), true);
            }
        }
        catch (StandardException mse) {
            throw new PassThroughException(mse);
        }
    }
}

