/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ValueNodeList
extends QueryTreeNodeVector {
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        for (int index = 0; index < this.size(); ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            valueNode.treePrint(depth + 1);
        }
    }

    public void addValueNode(ValueNode valueNode) throws StandardException {
        this.addElement(valueNode);
    }

    public void bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode vn = (ValueNode)this.elementAt(index);
            vn = vn.bindExpression(fromList, subqueryList, aggregateVector);
            this.setElementAt(vn, index);
        }
    }

    public void genSQLJavaSQLTrees() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (!valueNode.getTypeId().userType()) continue;
            this.setElementAt(valueNode.genSQLJavaSQLTree(), index);
        }
    }

    public DataTypeDescriptor getDominantTypeServices() throws StandardException {
        DataTypeDescriptor dominantDTS = null;
        int firstCollationDerivation = -1;
        int firstCollationType = -1;
        boolean foundCollationMisMatch = false;
        for (int index = 0; index < this.size(); ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (valueNode.requiresTypeFromContext()) continue;
            DataTypeDescriptor valueNodeDTS = valueNode.getTypeServices();
            if (valueNodeDTS.getTypeId().isStringTypeId()) {
                if (firstCollationDerivation == -1) {
                    firstCollationDerivation = valueNodeDTS.getCollationDerivation();
                    firstCollationType = valueNodeDTS.getCollationType();
                } else if (!foundCollationMisMatch) {
                    if (firstCollationDerivation != valueNodeDTS.getCollationDerivation()) {
                        foundCollationMisMatch = true;
                    } else if (firstCollationType != valueNodeDTS.getCollationType()) {
                        foundCollationMisMatch = true;
                    }
                }
            }
            dominantDTS = dominantDTS == null ? valueNodeDTS : dominantDTS.getDominantType(valueNodeDTS, this.getClassFactory());
        }
        if (firstCollationDerivation != -1 && foundCollationMisMatch) {
            dominantDTS = dominantDTS.getCollatedType(dominantDTS.getCollationType(), 0);
        }
        return dominantDTS;
    }

    public DataTypeDescriptor getTypeServices() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            DataTypeDescriptor valueNodeDTS = valueNode.getTypeServices();
            if (valueNodeDTS == null) continue;
            return valueNodeDTS;
        }
        return null;
    }

    boolean allSamePrecendence(int precedence) throws StandardException {
        boolean allSame = true;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            DataTypeDescriptor valueNodeDTS = valueNode.getTypeServices();
            if (valueNodeDTS == null) {
                return false;
            }
            if (precedence == valueNodeDTS.getTypeId().typePrecedence()) continue;
            return false;
        }
        return allSame;
    }

    public void compatible(ValueNode leftOperand) throws StandardException {
        int size = this.size();
        TypeId leftType = leftOperand.getTypeId();
        TypeCompiler leftTC = leftOperand.getTypeCompiler();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (valueNode.requiresTypeFromContext() || leftTC.compatible(valueNode.getTypeId())) continue;
            throw StandardException.newException("42815.S.171", (Object)leftType.getSQLTypeName(), (Object)valueNode.getTypeId().getSQLTypeName());
        }
    }

    public void comparable(ValueNode leftOperand) throws StandardException {
        int size = this.size();
        TypeId leftType = leftOperand.getTypeId();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (leftOperand.getTypeServices().comparable(valueNode.getTypeServices(), false, this.getClassFactory())) continue;
            throw StandardException.newException("42818", (Object)leftOperand.getTypeServices().getSQLTypeNameWithCollation(), (Object)valueNode.getTypeServices().getSQLTypeNameWithCollation());
        }
    }

    public boolean isNullable() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (!((ValueNode)this.elementAt(index)).getTypeServices().isNullable()) continue;
            return true;
        }
        return false;
    }

    public boolean containsParameterNode() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (!((ValueNode)this.elementAt(index)).requiresTypeFromContext()) continue;
            return true;
        }
        return false;
    }

    public boolean containsAllParameterNodes() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((ValueNode)this.elementAt(index)).requiresTypeFromContext()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAllConstantNodes() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if ((ValueNode)this.elementAt(index) instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    public boolean containsOnlyConstantAndParamNodes() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode vNode = (ValueNode)this.elementAt(index);
            if (vNode.requiresTypeFromContext() || vNode instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    void sortInAscendingOrder(DataValueDescriptor judgeODV) throws StandardException {
        int size = this.size();
        SanityManager.ASSERT(size > 0, "size() expected to be non-zero");
        boolean continueSort = true;
        while (continueSort) {
            continueSort = false;
            for (int index = 1; index < size; ++index) {
                ConstantNode currCN = (ConstantNode)this.elementAt(index);
                DataValueDescriptor currODV = currCN.getValue();
                ConstantNode prevCN = (ConstantNode)this.elementAt(index - 1);
                DataValueDescriptor prevODV = prevCN.getValue();
                if ((judgeODV != null || prevODV.compare(currODV) <= 0) && (judgeODV == null || !judgeODV.greaterThan(prevODV, currODV).equals(true))) continue;
                this.setElementAt(currCN, index - 1);
                this.setElementAt(prevCN, index);
                continueSort = true;
            }
        }
    }

    public void setParameterDescriptor(DataTypeDescriptor descriptor) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            if (!valueNode.requiresTypeFromContext()) continue;
            valueNode.setType(descriptor);
        }
    }

    public void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode valueNode = (ValueNode)this.elementAt(index);
            valueNode.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
    }

    public ValueNodeList remapColumnReferencesToExpressions() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            this.setElementAt(((ValueNode)this.elementAt(index)).remapColumnReferencesToExpressions(), index);
        }
        return this;
    }

    public boolean isConstantExpression() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            boolean retcode = ((ValueNode)this.elementAt(index)).isConstantExpression();
            if (retcode) continue;
            return retcode;
        }
        return true;
    }

    public boolean constantExpression(PredicateList whereClause) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            boolean retcode = ((ValueNode)this.elementAt(index)).constantExpression(whereClause);
            if (retcode) continue;
            return retcode;
        }
        return true;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = true;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            pushable = ((ValueNode)this.elementAt(index)).categorize(referencedTabs, simplePredsOnly) && pushable;
        }
        return pushable;
    }

    protected int getOrderableVariantType() throws StandardException {
        int listType = 3;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            int curType = ((ValueNode)this.elementAt(index)).getOrderableVariantType();
            listType = Math.min(listType, curType);
        }
        return listType;
    }
}

