/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ode.bpel.rtrep.v1.ACTIVITY;
import org.apache.ode.bpel.rtrep.v1.ActivityInfo;
import org.apache.ode.bpel.rtrep.v1.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v1.CompensationHandler;
import org.apache.ode.bpel.rtrep.v1.LinkFrame;
import org.apache.ode.bpel.rtrep.v1.OActivity;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.bpel.rtrep.v1.OSequence;
import org.apache.ode.bpel.rtrep.v1.ScopeFrame;
import org.apache.ode.bpel.rtrep.v1.channels.FaultData;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v1.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannel;
import org.apache.ode.bpel.rtrep.v1.channels.TerminationChannelListener;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SEQUENCE
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private final List<OActivity> _remaining;
    private final Set<CompensationHandler> _compensations;

    SEQUENCE(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        this(activityInfo, scopeFrame, linkFrame, ((OSequence)activityInfo.o).sequence, CompensationHandler.emptySet());
    }

    SEQUENCE(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame, List<OActivity> list, Set<CompensationHandler> set) {
        super(activityInfo, scopeFrame, linkFrame);
        this._remaining = Collections.unmodifiableList(list);
        this._compensations = Collections.unmodifiableSet(set);
    }

    public void run() {
        ActivityInfo activityInfo = new ActivityInfo(this.genMonotonic(), this._remaining.get(0), (TerminationChannel)this.newChannel(TerminationChannel.class), (ParentScopeChannel)this.newChannel(ParentScopeChannel.class));
        SEQUENCE.instance((JacobRunnable)this.createChild(activityInfo, this._scopeFrame, this._linkFrame));
        SEQUENCE.instance((JacobRunnable)new ACTIVE(activityInfo));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SEQUENCE(self=");
        stringBuffer.append(this._self);
        stringBuffer.append(", linkframe=");
        stringBuffer.append(this._linkFrame);
        stringBuffer.append(", remaining=");
        stringBuffer.append(this._remaining);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ACTIVE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -2663862698981385732L;
        private ActivityInfo _child;
        private boolean _terminateRequested = false;

        ACTIVE(ActivityInfo activityInfo) {
            this._child = activityInfo;
        }

        public void run() {
            ACTIVE.object((boolean)false, (Set)new TerminationChannelListener(SEQUENCE.this._self.self){
                private static final long serialVersionUID = -2680515407515637639L;

                public void terminate() {
                    ((TerminationChannel)2.replication((Channel)((ACTIVE)ACTIVE.this)._child.self)).terminate();
                    ArrayList arrayList = new ArrayList(SEQUENCE.this._remaining);
                    arrayList.remove(0);
                    ACTIVE.this.deadPathRemaining(arrayList);
                    ACTIVE.this._terminateRequested = true;
                    2.instance((JacobRunnable)ACTIVE.this);
                }
            }.or(new ParentScopeChannelListener(this._child.parent){
                private static final long serialVersionUID = 7195562310281985971L;

                @Override
                public void compensate(OScope oScope, SynchChannel synchChannel) {
                    SEQUENCE.this._self.parent.compensate(oScope, synchChannel);
                    1.instance((JacobRunnable)ACTIVE.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> set) {
                    TreeSet<CompensationHandler> treeSet = new TreeSet<CompensationHandler>(SEQUENCE.this._compensations);
                    treeSet.addAll(set);
                    if (faultData != null || ACTIVE.this._terminateRequested || SEQUENCE.this._remaining.size() <= 1) {
                        ACTIVE.this.deadPathRemaining(SEQUENCE.this._remaining);
                        SEQUENCE.this._self.parent.completed(faultData, treeSet);
                    } else {
                        ArrayList<OActivity> arrayList = new ArrayList<OActivity>(SEQUENCE.this._remaining);
                        arrayList.remove(0);
                        1.instance((JacobRunnable)new SEQUENCE(SEQUENCE.this._self, SEQUENCE.this._scopeFrame, SEQUENCE.this._linkFrame, arrayList, treeSet));
                    }
                }

                @Override
                public void cancelled() {
                    this.completed(null, CompensationHandler.emptySet());
                }

                @Override
                public void failure(String string, Element element) {
                    this.completed(null, CompensationHandler.emptySet());
                }
            }));
        }

        private void deadPathRemaining(List<OActivity> list) {
            Iterator<OActivity> iterator = list.iterator();
            while (iterator.hasNext()) {
                SEQUENCE.this.dpe(iterator.next());
            }
        }
    }
}

