/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.definitions;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.definitions.DefinitionBase;
import org.eclipse.smila.common.definitions.ValueExpression;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.definitions.DataObjectTypeModeDefinition;

public class DataObjectTypeDefinition
extends DefinitionBase {
    public static final String KEY_DATA_OBJECT_TYPE_DEFINITIONS = "dataObjectTypes";
    private final Map<Mode, DataObjectTypeModeDefinition> _modeDefinitions = new LinkedHashMap<Mode, DataObjectTypeModeDefinition>(2);

    public DataObjectTypeDefinition(AnyMap dotAny) throws InvalidDefinitionException {
        super(dotAny);
        AnyMap transDefAny;
        AnyMap persDefAny = (AnyMap)AccessAny.get((AnyMap)dotAny, (String)Mode.PERSISTENT.toString(), (Any.ValueType)Any.ValueType.MAP);
        if (persDefAny != null) {
            this._modeDefinitions.put(Mode.PERSISTENT, new DataObjectTypeModeDefinition(persDefAny));
        }
        if ((transDefAny = (AnyMap)AccessAny.get((AnyMap)dotAny, (String)Mode.TRANSIENT.toString(), (Any.ValueType)Any.ValueType.MAP)) != null) {
            this._modeDefinitions.put(Mode.TRANSIENT, new DataObjectTypeModeDefinition(transDefAny));
        }
        if (persDefAny == null && transDefAny == null) {
            throw new InvalidDefinitionException("You have to set at least one of 'transient' or 'persistent' mode");
        }
    }

    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap dotAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes && this._modeDefinitions != null && !this._modeDefinitions.isEmpty()) {
                for (Mode mode : this._modeDefinitions.keySet()) {
                    DataObjectTypeModeDefinition modeDef = this._modeDefinitions.get((Object)mode);
                    dotAny.put(mode.toString(), modeDef.toAny());
                }
            }
            return dotAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for data object type " + this._name, ex);
        }
    }

    public ValueExpression getObject(Mode mode) {
        if (this._modeDefinitions.get((Object)mode) != null) {
            return this._modeDefinitions.get((Object)mode).getObject();
        }
        return null;
    }

    public ValueExpression getStore(Mode mode) {
        if (this._modeDefinitions.get((Object)mode) != null) {
            return this._modeDefinitions.get((Object)mode).getStore();
        }
        return null;
    }

    public boolean hasPersistentMode() {
        return this._modeDefinitions.get((Object)Mode.PERSISTENT) != null;
    }

    public boolean hasTransientMode() {
        return this._modeDefinitions.get((Object)Mode.TRANSIENT) != null;
    }

    public static enum Mode {
        TRANSIENT("transient"),
        PERSISTENT("persistent");

        private final String _name;

        private Mode(String n2) {
            this._name = n2;
        }

        public String toString() {
            return this._name;
        }
    }
}

