/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.taskgenerator;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorProvider;

public class TaskGeneratorProviderImpl
implements TaskGeneratorProvider {
    private final Map<String, TaskGenerator> _taskGenerators = new HashMap<String, TaskGenerator>();
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public TaskGenerator getTaskGenerator(WorkerDefinition worker) {
        TaskGenerator taskGenerator = worker.getTaskGenerator() != null && !worker.getTaskGenerator().equals("") ? this.getTaskGenerator(worker.getTaskGenerator()) : this.getDefaultTaskGenerator();
        return taskGenerator;
    }

    @Override
    public TaskGenerator getTaskGenerator(String taskGeneratorName) {
        if (this._taskGenerators.containsKey(taskGeneratorName)) {
            return this._taskGenerators.get(taskGeneratorName);
        }
        throw new IllegalArgumentException("Could not find TaskGenerator for name '" + taskGeneratorName + "'");
    }

    @Override
    public TaskGenerator getDefaultTaskGenerator() {
        return this.getTaskGenerator("default");
    }

    public synchronized void addTaskGenerator(TaskGenerator taskGenerator) {
        this._log.info((Object)("Have TaskGenerator '" + taskGenerator.getName() + "', class " + taskGenerator.getClass().getName()));
        this._taskGenerators.put(taskGenerator.getName(), taskGenerator);
    }

    public synchronized void removeTaskGenerator(TaskGenerator taskGenerator) {
        if (this._taskGenerators.values().contains(taskGenerator)) {
            this._taskGenerators.remove(taskGenerator.getName());
        }
    }
}

