/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.compound.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.common.mimetype.MimeTypeIdentifier;
import org.eclipse.smila.common.mimetype.MimeTypeParseException;
import org.eclipse.smila.connectivity.framework.Crawler;
import org.eclipse.smila.connectivity.framework.compound.CompoundException;
import org.eclipse.smila.connectivity.framework.compound.CompoundHandler;
import org.eclipse.smila.connectivity.framework.compound.CompoundManager;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;

public class CompoundManagerImpl
implements CompoundManager {
    private final Log _log = LogFactory.getLog(CompoundManagerImpl.class);
    private List<CompoundHandler> _compoundHandlers;
    private MimeTypeIdentifier _mimeTypeIdentifier;

    public CompoundManagerImpl() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Creating CompoundManagerImpl");
        }
    }

    public void addCompoundHandler(CompoundHandler compoundHandler) {
        if (this._compoundHandlers == null) {
            this._compoundHandlers = new ArrayList<CompoundHandler>();
        }
        this._compoundHandlers.add(compoundHandler);
        this._log.debug((Object)("CompoundHandler registered: " + compoundHandler.toString() + " - " + this.toString()));
    }

    public void removeCompoundHandler(CompoundHandler compoundHandler) {
        if (this._compoundHandlers != null) {
            this._compoundHandlers.remove(compoundHandler);
        }
        this._log.debug((Object)("CompoundHandler unregistered: " + compoundHandler.toString() + " - " + this.toString()));
    }

    public void setMimeTypeIdentifier(MimeTypeIdentifier mimeTypeIdentifier) {
        this._mimeTypeIdentifier = mimeTypeIdentifier;
    }

    public void unsetMimeTypeIdentifier(MimeTypeIdentifier mimeTypeIdentifier) {
        if (this._mimeTypeIdentifier == mimeTypeIdentifier) {
            this._mimeTypeIdentifier = null;
        }
    }

    public boolean isCompound(Record record, DataSourceConnectionConfig config) throws CompoundException {
        if (record == null) {
            throw new CompoundException("parameter record is null");
        }
        if (config == null) {
            throw new CompoundException("parameter config is null");
        }
        String mimeType = this.getMimeType(record, config);
        return this.findCompoundHandler(mimeType) != null;
    }

    public Crawler extract(Record record, DataSourceConnectionConfig config) throws CompoundException {
        if (record == null) {
            throw new CompoundException("parameter record is null");
        }
        if (config == null) {
            throw new CompoundException("parameter config is null");
        }
        String mimeType = this.getMimeType(record, config);
        CompoundHandler compoundHandler = this.findCompoundHandler(mimeType);
        if (compoundHandler != null) {
            if (record.hasAttachment(config.getCompoundHandling().getContentAttachment())) {
                return compoundHandler.extract(record, config);
            }
            throw new CompoundException("record " + record.getId() + " does not contain attachment " + config.getCompoundHandling().getContentAttachment());
        }
        return null;
    }

    public Record adaptCompoundRecord(Record record, DataSourceConnectionConfig config) throws CompoundException {
        if (record == null) {
            throw new CompoundException("parameter record is null");
        }
        if (config == null) {
            throw new CompoundException("parameter config is null");
        }
        return record;
    }

    private CompoundHandler findCompoundHandler(String mimeType) {
        if (this._compoundHandlers != null) {
            for (CompoundHandler compoundHandler : this._compoundHandlers) {
                Collection supportedMimeTypes = compoundHandler.getSupportedMimeTypes();
                if (supportedMimeTypes == null || !supportedMimeTypes.contains(mimeType)) continue;
                return compoundHandler;
            }
        }
        return null;
    }

    private String getMimeType(Record record, DataSourceConnectionConfig config) throws CompoundException {
        String mimeType = null;
        String mimeTypeAttributeName = config.getCompoundHandling().getMimeTypeAttribute();
        if (mimeTypeAttributeName != null && record.getMetadata().containsKey((Object)mimeTypeAttributeName) && ((Any)record.getMetadata().get((Object)mimeTypeAttributeName)).isString()) {
            mimeType = record.getMetadata().getStringValue(mimeTypeAttributeName);
        }
        if (mimeType == null) {
            mimeType = this.identifyMimeType(record, config);
            this.setMimeTypeAttribute(record, mimeTypeAttributeName, mimeType);
        }
        return mimeType;
    }

    private String identifyMimeType(Record record, DataSourceConnectionConfig config) throws CompoundException {
        String extension = null;
        String extensionAttributeName = config.getCompoundHandling().getExtensionAttribute();
        if (extensionAttributeName != null && record.getMetadata().containsKey((Object)extensionAttributeName) && ((Any)record.getMetadata().get((Object)extensionAttributeName)).isString()) {
            extension = record.getMetadata().getStringValue(extensionAttributeName);
        }
        String attachmentName = config.getCompoundHandling().getContentAttachment();
        byte[] content = record.getAttachmentAsBytes(attachmentName);
        try {
            return this._mimeTypeIdentifier.identify(content, extension);
        }
        catch (MimeTypeParseException e) {
            String msg = "Error identifying mimetype for record " + record.getId();
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new CompoundException(msg, (Throwable)e);
        }
    }

    private void setMimeTypeAttribute(Record record, String mimeTypeAttributeName, String mimeType) {
        record.getMetadata().put(mimeTypeAttributeName, (Any)record.getFactory().createStringValue(mimeType));
    }
}

