/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingException;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingSessionException;
import org.eclipse.smila.connectivity.framework.Agent;
import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.AgentCriticalException;
import org.eclipse.smila.connectivity.framework.AgentState;
import org.eclipse.smila.connectivity.framework.State;
import org.eclipse.smila.connectivity.framework.impl.AbstractController;
import org.eclipse.smila.connectivity.framework.impl.ImportRunIdHelper;
import org.eclipse.smila.connectivity.framework.performancecounters.AgentPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.schema.config.DataConnectionID;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.schema.config.DeltaIndexingType;
import org.eclipse.smila.connectivity.framework.util.AgentControllerCallback;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.osgi.service.component.ComponentContext;

public class AgentControllerImpl
extends AbstractController
implements AgentController {
    private static final String BUNDLE_ID = "org.eclipse.smila.connectivity.framework";
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Map<String, Agent> _activeAgents;
    private final Map<String, AgentState> _agentStates;
    private final Map<String, AgentPerformanceCounterHelper<? extends ConnectivityPerformanceAgent>> _agentCounters;

    public AgentControllerImpl() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Creating AgentControllerImpl");
        }
        this._activeAgents = new HashMap<String, Agent>();
        this._agentStates = new HashMap<String, AgentState>();
        this._agentCounters = new HashMap<String, AgentPerformanceCounterHelper<? extends ConnectivityPerformanceAgent>>();
    }

    public AgentPerformanceCounterHelper<? extends ConnectivityPerformanceAgent> getPerformanceCounterHelper(String dataSourceId) {
        Agent agent = this._activeAgents.get(dataSourceId);
        if (agent != null) {
            return agent.getCounterHelper();
        }
        return this._agentCounters.get(dataSourceId);
    }

    public int startAgent(String dataSourceId, String jobName) throws ConnectivityException {
        this.assertNotEmpty(dataSourceId, "dataSourceId");
        this.assertNotEmpty(jobName, "jobName");
        if (this._activeAgents.containsKey(dataSourceId)) {
            throw new ConnectivityException("Can't start a new agent for DataSourceId '" + dataSourceId + "'. An agent is already started for it.");
        }
        try {
            DataSourceConnectionConfig configuration = this.getConfiguration(BUNDLE_ID, dataSourceId);
            this.getConnectivityManager().checkJobIsActive(jobName);
            Agent agent = this.createInstance(Agent.class, configuration.getDataConnectionID().getId());
            int importRunId = agent.hashCode();
            AgentState agentState = new AgentState();
            agentState.setImportRunId(Integer.toString(importRunId));
            this._agentStates.put(dataSourceId, agentState);
            String sessionId = null;
            if (this.doDeltaIndexing(configuration.getDeltaIndexing())) {
                sessionId = this.getDeltaIndexingManager().init(dataSourceId);
            }
            agent.start((AgentControllerCallback)new Callback(this, jobName), agentState, configuration, sessionId);
            agent.getCounterHelper().setJobName(jobName);
            this._activeAgents.put(dataSourceId, agent);
            return importRunId;
        }
        catch (ConnectivityException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error during start of agent using DataSourceId '" + dataSourceId + "'";
            this._log.error((Object)msg, (Throwable)e);
            throw new ConnectivityException(msg, (Throwable)e);
        }
    }

    public void stopAgent(String dataSourceId) throws ConnectivityException {
        this.assertNotEmpty(dataSourceId, "dataSourceId");
        Agent agent = this._activeAgents.get(dataSourceId);
        if (agent == null) {
            String msg = "Could not stop Agent for DataSourceId '" + dataSourceId + "'. No agent has been started for it.";
            this._log.error((Object)msg);
            throw new ConnectivityException(msg);
        }
        try {
            agent.stop();
        }
        catch (Exception e) {
            String msg = "Error while stopping agent for DataSourceId '" + dataSourceId + "'";
            this._log.error((Object)msg, (Throwable)e);
            throw new ConnectivityException(msg, (Throwable)e);
        }
    }

    public boolean hasActiveAgents() throws ConnectivityException {
        return !this._activeAgents.isEmpty();
    }

    public Map<String, AgentState> getAgentTasksState() {
        HashMap<String, AgentState> states = new HashMap<String, AgentState>();
        states.putAll(this._agentStates);
        return states;
    }

    public Collection<String> getAvailableAgents() {
        return this.getAvailableFactories();
    }

    public Collection<String> getAvailableConfigurations() {
        return this.getConfigurations(BUNDLE_ID, DataConnectionID.DataConnectionType.AGENT);
    }

    public void add(String sessionId, DeltaIndexingType deltaIndexingType, Record record, String hash, String jobName) throws AgentCriticalException {
        if (record != null) {
            ImportRunIdHelper.setImportRunIdAttribute(record, (State)this._agentStates.get(record.getSource()));
            try {
                boolean isUpdate = true;
                if (this.doCheckForUpdate(deltaIndexingType)) {
                    isUpdate = this.getDeltaIndexingManager().checkForUpdate(sessionId, new ConnectivityId(record.getSource(), record.getId()), hash);
                }
                if (isUpdate) {
                    this.getConnectivityManager().add(new Record[]{record}, jobName);
                    if (this.doDeltaIndexing(deltaIndexingType)) {
                        this.getDeltaIndexingManager().visit(sessionId, new ConnectivityId(record.getSource(), record.getId()), hash, false);
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (ConnectivityException e) {
                String msg = "Error while deleting records for DataSourceId '" + record.getSource() + "'";
                if (e.isRecoverable()) {
                    this._log.error((Object)msg, (Throwable)e);
                }
                throw new AgentCriticalException(msg, (Throwable)e);
            }
            catch (DeltaIndexingSessionException e) {
                String msg = "Error while deleting records for DataSourceId '" + record.getSource() + "'";
                this._log.error((Object)msg, (Throwable)e);
            }
            catch (DeltaIndexingException e) {
                String msg = "Error while deleting records for DataSourceId '" + record.getSource() + "'";
                this._log.error((Object)msg, (Throwable)e);
            }
        }
    }

    public void delete(String sessionId, DeltaIndexingType deltaIndexingType, ConnectivityId id, String jobName) throws AgentCriticalException {
        if (id != null) {
            String dataSourceId = id.getDataSourceId();
            try {
                Record record = DataFactory.DEFAULT.createRecord();
                ImportRunIdHelper.setImportRunIdAttribute(record, (State)this._agentStates.get(record.getSource()));
                this.getConnectivityManager().delete(new Record[]{record}, jobName);
                if (this.doDeltaDelete(deltaIndexingType)) {
                    this.getDeltaIndexingManager().delete(sessionId, id);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (ConnectivityException e) {
                String msg = "Error while deleting records for DataSourceId '" + dataSourceId + "'";
                if (e.isRecoverable()) {
                    this._log.error((Object)msg, (Throwable)e);
                }
                throw new AgentCriticalException(msg, (Throwable)e);
            }
            catch (DeltaIndexingSessionException e) {
                String msg = "Error while deleting records for DataSourceId '" + dataSourceId + "'";
                this._log.error((Object)msg, (Throwable)e);
            }
            catch (DeltaIndexingException e) {
                String msg = "Error while deleting records for DataSourceId '" + dataSourceId + "'";
                this._log.error((Object)msg, (Throwable)e);
            }
        }
    }

    public void unregister(String sessionId, DeltaIndexingType deltaIndexingType, String dataSourceId) {
        Agent removedAgent = this._activeAgents.remove(dataSourceId);
        if (removedAgent != null) {
            this._agentCounters.put(dataSourceId, (AgentPerformanceCounterHelper<? extends ConnectivityPerformanceAgent>)removedAgent.getCounterHelper());
        }
        if (this.doDeltaIndexing(deltaIndexingType)) {
            try {
                this.getDeltaIndexingManager().finish(sessionId);
            }
            catch (Exception e) {
                String msg = "Error finishing delta indexing for DataSourceId '" + dataSourceId + "'";
                this._log.error((Object)msg, (Throwable)e);
            }
        }
    }

    private int deleteDelta(String sessionId, DeltaIndexingType deltaIndexingType, String compoundId) {
        int count = 0;
        if (this.doDeltaDelete(deltaIndexingType)) {
            try {
                Iterator it = this.getDeltaIndexingManager().obsoleteIdIterator(sessionId, compoundId);
                if (it != null) {
                    while (it.hasNext()) {
                        ConnectivityId id = (ConnectivityId)it.next();
                        if (id == null) continue;
                        this.getDeltaIndexingManager().delete(sessionId, (ConnectivityId)it.next());
                        ++count;
                    }
                }
            }
            catch (Exception e) {
                String msg = "Error during execution of deleteDelta for compoundId " + compoundId;
                this._log.error((Object)msg, (Throwable)e);
            }
        }
        return count;
    }

    protected void deactivate(ComponentContext context) throws Exception {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)"Deactivating AgentController");
        }
        this._lock.writeLock().lock();
        try {
            for (Map.Entry<String, Agent> entry : this._activeAgents.entrySet()) {
                try {
                    if (entry.getValue() == null) continue;
                    entry.getValue().stop();
                }
                catch (Exception e) {
                    this._log.error((Object)("Error stopping Agent for data source " + entry.getKey()), (Throwable)e);
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    private static class Callback
    implements AgentControllerCallback {
        private final AgentControllerImpl _controller;
        private final String _jobName;

        public Callback(AgentControllerImpl controller, String jobName) {
            this._controller = controller;
            this._jobName = jobName;
        }

        public boolean doDeltaIndexing(DeltaIndexingType deltaIndexingType) {
            return this._controller.doDeltaIndexing(deltaIndexingType);
        }

        public boolean doCheckForUpdate(DeltaIndexingType deltaIndexingType) {
            return this._controller.doCheckForUpdate(deltaIndexingType);
        }

        public boolean doDeltaDelete(DeltaIndexingType deltaIndexingType) {
            return this._controller.doDeltaDelete(deltaIndexingType);
        }

        public void add(String sessionId, DeltaIndexingType deltaIndexingType, Record record, String hash) throws AgentCriticalException {
            this._controller.add(sessionId, deltaIndexingType, record, hash, this._jobName);
        }

        public void delete(String sessionId, DeltaIndexingType deltaIndexingType, ConnectivityId id) throws AgentCriticalException {
            this._controller.delete(sessionId, deltaIndexingType, id, this._jobName);
        }

        public void unregister(String sessionId, DeltaIndexingType deltaIndexingType, String dataSourceId) {
            this._controller.unregister(sessionId, deltaIndexingType, dataSourceId);
        }
    }
}

