/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.deploy;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.ODEServer;

public class DeploymentPoller {
    private static Log __log = LogFactory.getLog(DeploymentPoller.class);
    private static final long POLL_TIME = 3000L;
    private File _deployDir;
    private PollingThread _poller;
    private ODEServer _odeServer;
    private boolean _onHold = false;
    private static final FileFilter _fileFilter = new FileFilter(){

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.toLowerCase().equals("deploy.xml");
                    }
                }).length == 1;
            }
            return false;
        }
    };
    private static final FileFilter _deployedFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".deployed");
        }
    };

    public DeploymentPoller(File file, ODEServer oDEServer) {
        this._odeServer = oDEServer;
        this._deployDir = file;
        if (!this._deployDir.exists()) {
            this._deployDir.mkdir();
        }
    }

    public void start() {
        this._poller = new PollingThread();
        this._poller.start();
        __log.info((Object)"Poller started.");
    }

    public void stop() {
        this._poller.kill();
        this._poller = null;
    }

    private void check() {
        Object object;
        Object object2;
        File[] fileArray;
        File[] fileArray2 = fileArray = this._deployDir.listFiles(_fileFilter);
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file = fileArray2[i];
            File file2 = new File(file, "deploy.xml");
            object2 = new File(this._deployDir, file.getName() + ".deployed");
            if (!file2.exists()) {
                __log.debug((Object)("Not deploying " + file + " (missing deploy.xml)"));
            }
            if (((File)object2).exists()) continue;
            try {
                ((File)object2).createNewFile();
            }
            catch (IOException iOException) {
                __log.error((Object)("Error creating deployed marker file, " + file + " will not be deployed"));
                continue;
            }
            try {
                this._odeServer.getProcessStore().undeploy(file);
            }
            catch (Exception exception) {
                __log.error((Object)("Error undeploying " + file.getName()));
            }
            try {
                object = this._odeServer.getProcessStore().deploy(file);
                __log.info((Object)("Deployment of artifact " + file.getName() + " successful: " + object));
                continue;
            }
            catch (Exception exception) {
                __log.error((Object)("Deployment of " + file.getName() + " failed, aborting for now."), (Throwable)exception);
            }
        }
        for (File file2 : fileArray2 = this._deployDir.listFiles(_deployedFilter)) {
            object2 = file2.getName().substring(0, file2.getName().length() - ".deployed".length());
            object = new File(this._deployDir, (String)object2);
            if (((File)object).exists()) continue;
            Collection collection = this._odeServer.getProcessStore().undeploy((File)object);
            file2.delete();
            if (collection.size() <= 0) continue;
            __log.info((Object)("Successfully undeployed " + (String)object2));
        }
    }

    public void hold() {
        this._onHold = true;
    }

    public void release() {
        this._onHold = false;
    }

    public void markAsDeployed(File file) {
        File file2 = new File(this._deployDir, file.getName() + ".deployed");
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            __log.error((Object)("Couldn't create marker file for " + file.getName()));
        }
    }

    public void markAsUndeployed(File file) {
        File file2 = new File(this._deployDir, file.getName() + ".deployed");
        file2.delete();
    }

    private class PollingThread
    extends Thread {
        private boolean _active = true;

        private PollingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            PollingThread pollingThread = this;
            synchronized (pollingThread) {
                this._active = false;
                this.notifyAll();
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                __log.fatal((Object)"Thread unexpectedly interrupted.", (Throwable)interruptedException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (this._active) {
                    if (!DeploymentPoller.this._onHold) {
                        DeploymentPoller.this.check();
                    }
                    PollingThread pollingThread = this;
                    synchronized (pollingThread) {
                        try {
                            this.wait(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                __log.fatal((Object)"Encountered an unexpected error.  Exiting poller...", throwable);
            }
        }
    }
}

