/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import org.apache.commons.lang.StringUtils;
import org.apache.ode.axis2.httpbinding.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;

public class HttpBindingValidator {
    private static final Messages httpMsgs = (Messages)Messages.getMessages(Messages.class);
    private static final org.apache.ode.utils.wsdl.Messages wsdlMsgs = (org.apache.ode.utils.wsdl.Messages)Messages.getMessages(org.apache.ode.utils.wsdl.Messages.class);
    protected Binding binding;

    public HttpBindingValidator(Binding binding) {
        this.binding = binding;
        if (!WsdlUtils.useHTTPBinding((Binding)binding)) {
            throw new IllegalArgumentException(httpMsgs.msgHttpBindingNotUsed(binding));
        }
    }

    public void validate() throws IllegalArgumentException {
        this.validatePort();
    }

    protected void validatePort() {
        for (int i = 0; i < this.binding.getBindingOperations().size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)this.binding.getBindingOperations().get(i);
            this.validateOperation(bindingOperation);
        }
    }

    protected void validateOperation(BindingOperation bindingOperation) {
        String string;
        String string2 = WsdlUtils.resolveVerb((Binding)this.binding, (BindingOperation)bindingOperation);
        if (string2 == null) {
            throw new IllegalArgumentException(httpMsgs.msgMissingVerb(this.binding, bindingOperation));
        }
        if (!("GET".equalsIgnoreCase(string2) || "DELETE".equalsIgnoreCase(string2) || "PUT".equalsIgnoreCase(string2) || "POST".equalsIgnoreCase(string2))) {
            throw new IllegalArgumentException(httpMsgs.msgUnsupportedHttpMethod(this.binding, string2));
        }
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        MIMEContent mIMEContent = WsdlUtils.getMimeContent((List)bindingOutput.getExtensibilityElements());
        if (mIMEContent != null && StringUtils.isEmpty((String)mIMEContent.getType())) {
            throw new IllegalArgumentException(httpMsgs.msgEmptyContentType(this.binding, bindingOperation));
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (WsdlUtils.useMimeMultipartRelated((BindingInput)bindingInput)) {
            throw new IllegalArgumentException(httpMsgs.msgMimeMultipartRelatedUnsupported(this.binding, bindingOperation));
        }
        MIMEContent mIMEContent2 = WsdlUtils.getMimeContent((List)bindingInput.getExtensibilityElements());
        if (mIMEContent2 != null && StringUtils.isEmpty((String)(string = mIMEContent2.getType()))) {
            throw new IllegalArgumentException(httpMsgs.msgEmptyContentType(this.binding, bindingOperation));
        }
        if (WsdlUtils.useUrlReplacement((BindingInput)bindingInput)) {
            this.validateUrlReplacement(bindingOperation);
        }
        if ("GET".equalsIgnoreCase(string2) || "DELETE".equalsIgnoreCase(string2)) {
            this.validateGetOrDelete(bindingOperation);
        }
    }

    protected void validateGetOrDelete(BindingOperation bindingOperation) {
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (!WsdlUtils.useUrlEncoded((BindingInput)bindingInput) && !WsdlUtils.useUrlReplacement((BindingInput)bindingInput)) {
            throw new IllegalArgumentException(httpMsgs.msgOnlySupportsUrlEncodedAndUrlreplacement(this.binding, bindingOperation));
        }
    }

    protected void validateUrlReplacement(BindingOperation bindingOperation) {
        HTTPOperation hTTPOperation = (HTTPOperation)WsdlUtils.getOperationExtension((BindingOperation)bindingOperation);
        BindingInput bindingInput = bindingOperation.getBindingInput();
        Map map = bindingOperation.getOperation().getInput().getMessage().getParts();
        if (WsdlUtils.useUrlReplacement((BindingInput)bindingInput)) {
            String string = hTTPOperation.getLocationURI();
            Set set = map.keySet();
            for (String string2 : set) {
                Pattern pattern = Pattern.compile(".*(\\(" + string2 + "\\)).*");
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches() || string.split("(\\(" + string2 + "\\))", -1).length == 2) continue;
                throw new IllegalArgumentException(httpMsgs.msgInvalidURIPattern(this.binding, bindingOperation, string));
            }
        }
    }
}

