/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ipc.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.smila.ipc.IpcStreamReader;
import org.eclipse.smila.ipc.IpcToken;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.ipc.bon.BinaryStreamWriter;
import org.eclipse.smila.ipc.json.JsonFactory;
import org.eclipse.smila.ipc.json.JsonStreamReader;
import org.eclipse.smila.ipc.util.IpcValidator;

public class Ipc2BonTrafo {
    private IpcValidator _validator;
    private boolean _validate;
    private final JsonFactory _jsonFactory = new JsonFactory();
    private final BinaryFactory _bonFactory = new BinaryFactory();

    public Ipc2BonTrafo() {
        this._validate = false;
    }

    public Ipc2BonTrafo(IpcValidator validator) {
        this._validator = validator;
        this._validate = true;
    }

    public void json2bon(InputStream input, OutputStream output) throws IOException {
        JsonStreamReader reader = this._jsonFactory.newStreamReader(input);
        BinaryStreamWriter writer = this._bonFactory.newStreamWriter(output);
        try {
            this.ipc2bon(reader, writer);
        }
        finally {
            writer.closeWithoutStream();
            reader.closeWithoutStream();
        }
    }

    public void ipc2bon(IpcStreamReader ipcReader, BinaryStreamWriter bonWriter) throws IOException {
        IpcToken token = null;
        do {
            token = ipcReader.nextToken();
            if (this._validate) {
                this._validator.validate(token, ipcReader.currentStringValue());
            }
            this.writeToken(ipcReader, bonWriter, token);
        } while (token != IpcToken.OBJECT_END);
    }

    private void writeToken(IpcStreamReader ipcReader, BinaryStreamWriter bonWriter, IpcToken token) throws IOException {
        switch (token) {
            case MAPPING_START: {
                bonWriter.writeMappingStart();
                break;
            }
            case MAPPING_END: {
                bonWriter.writeMappingEnd();
                break;
            }
            case SEQUENCE_START: {
                bonWriter.writeSequenceStart();
                break;
            }
            case SEQUENCE_END: {
                bonWriter.writeSequenceEnd();
                break;
            }
            case SCALAR_STRING: {
                bonWriter.writeScalarString(ipcReader.currentStringValue());
                break;
            }
            case SCALAR_INT: {
                bonWriter.writeScalarLong(ipcReader.currentLongValue());
                break;
            }
            case SCALAR_BOOL: {
                bonWriter.writeScalarBoolean(ipcReader.currentBoolValue());
                break;
            }
            case SCALAR_DOUBLE: {
                bonWriter.writeScalarDouble(ipcReader.currentDoubleValue());
                break;
            }
            case OBJECT_START: {
                bonWriter.writeObjectStart();
                break;
            }
            case OBJECT_END: {
                bonWriter.writeObjectEnd();
                break;
            }
            default: {
                throw new IOException("Unexpected token " + (Object)((Object)token));
            }
        }
    }
}

