/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;

public final class FileToRecordConverter {
    public static final String PROPERTY_FILE_NAME = "file.name";
    public static final String PROPERTY_FILE_PATH = "file.path";
    public static final String PROPERTY_FILE_FOLDER = "file.folder";
    public static final String PROPERTY_FILE_SIZE = "file.size";
    public static final String PROPERTY_FILE_LAST_MODIFIED = "file.lastModified";
    public static final String PROPERTY_FILE_EXTENSION = "file.extension";
    public static final String ATTACHMENT_FILE_CONTENT = "file.content";
    private final DataFactory _factory;

    public FileToRecordConverter(DataFactory factory) {
        this._factory = factory;
    }

    public Record fileToRecord(File file, String dataSource, boolean withContent) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("parameter file is a directory");
        }
        Record record = this.createRecord(file, dataSource);
        this.addFileProperties(file, record);
        record.getMetadata().put("_deltaHash", Long.toString(file.lastModified()));
        if (withContent) {
            this.addAttachment(record);
        }
        return record;
    }

    public Record dirToRecord(File directory, String dataSource) {
        if (directory.isFile()) {
            throw new IllegalArgumentException("parameter directory is not a directory");
        }
        Record record = this.createRecord(directory, dataSource);
        record.getMetadata().put(PROPERTY_FILE_FOLDER, directory.getAbsolutePath());
        return record;
    }

    public void addAttachment(Record record) throws IOException {
        String path = record.getMetadata().getStringValue(PROPERTY_FILE_PATH);
        if (path == null) {
            throw new IllegalArgumentException("Record '" + record.getId() + "' does not contain attribute '" + PROPERTY_FILE_PATH + "'");
        }
        record.setAttachment(ATTACHMENT_FILE_CONTENT, FileUtils.readFileToByteArray((File)new File(path)));
    }

    private Record createRecord(File file, String dataSource) {
        return this._factory.createRecord(file.getAbsolutePath(), dataSource);
    }

    private void addFileProperties(File file, Record record) {
        record.getMetadata().put(PROPERTY_FILE_NAME, file.getName());
        record.getMetadata().put(PROPERTY_FILE_PATH, file.getAbsolutePath());
        record.getMetadata().put(PROPERTY_FILE_FOLDER, file.getParent());
        record.getMetadata().put(PROPERTY_FILE_SIZE, (Number)file.length());
        Value lastModifiedDate = this._factory.createDateTimeValue(new Date(file.lastModified()));
        record.getMetadata().put(PROPERTY_FILE_LAST_MODIFIED, (Any)lastModifiedDate);
        record.getMetadata().put(PROPERTY_FILE_EXTENSION, FilenameUtils.getExtension((String)file.getName()));
    }
}

