/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.deltaindexing;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingException;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingManager;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingManagerAgent;
import org.eclipse.smila.management.DeclarativeServiceManagementAgent;

public abstract class AbstractDeltaIndexingManagerAgent
extends DeclarativeServiceManagementAgent<DeltaIndexingManager>
implements DeltaIndexingManagerAgent {
    protected String getCategory() {
        return null;
    }

    protected String getName() {
        return "DeltaIndexing";
    }

    @Override
    public String clear(String dataSourceID) {
        try {
            this.checkDataSource(dataSourceID);
            String sessionId = ((DeltaIndexingManager)this._service).init(dataSourceID);
            ((DeltaIndexingManager)this._service).clear(sessionId);
            ((DeltaIndexingManager)this._service).finish(sessionId);
            return "OK";
        }
        catch (Throwable e) {
            this._log.error((Object)"", e);
            return this.getErrorMessage(e);
        }
    }

    @Override
    public String clearAll() {
        try {
            ((DeltaIndexingManager)this._service).clear();
            return "OK";
        }
        catch (Throwable e) {
            this._log.error((Object)"", e);
            return this.getErrorMessage(e);
        }
    }

    @Override
    public String unlock(String dataSourceID) {
        try {
            this.checkDataSource(dataSourceID);
            ((DeltaIndexingManager)this._service).unlockDatasource(dataSourceID);
            return "OK";
        }
        catch (Throwable e) {
            this._log.error((Object)"", e);
            return this.getErrorMessage(e);
        }
    }

    @Override
    public String unlockAll() {
        try {
            ((DeltaIndexingManager)this._service).unlockDatasources();
            return "OK";
        }
        catch (Throwable e) {
            this._log.error((Object)"", e);
            return this.getErrorMessage(e);
        }
    }

    @Override
    public Map<String, String> getLockStates() {
        try {
            HashMap<String, String> states = new HashMap<String, String>();
            Map<String, DeltaIndexingManager.LockState> lockStates = ((DeltaIndexingManager)this._service).getLockStates();
            for (Map.Entry<String, DeltaIndexingManager.LockState> lockStateEntry : lockStates.entrySet()) {
                states.put(lockStateEntry.getKey(), lockStateEntry.getValue().name());
            }
            return states;
        }
        catch (Throwable e) {
            this._log.error((Object)"", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public Object getEntryCount(String dataSourceID) {
        try {
            this.checkDataSource(dataSourceID);
            return ((DeltaIndexingManager)this._service).getEntryCount(dataSourceID);
        }
        catch (Throwable e) {
            this._log.error((Object)"", e);
            return this.getErrorMessage(e);
        }
    }

    @Override
    public Map<String, Long> getEntryCounts() {
        try {
            return ((DeltaIndexingManager)this._service).getEntryCounts();
        }
        catch (Throwable e) {
            this._log.error((Object)"", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void checkDataSource(String dataSourceID) throws DeltaIndexingException {
        if (!((DeltaIndexingManager)this._service).exists(dataSourceID)) {
            throw new DeltaIndexingException(String.format("Unable to find index for datasource [%s]", dataSourceID));
        }
    }

    protected String getErrorMessage(Throwable ex) {
        String message = ex.getMessage();
        if (message == null || message.length() == 0) {
            message = ex.toString();
        }
        return "Error: " + message;
    }
}

