/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Peter Wissel (brox IT Solutions GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.solr;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.search.api.QueryConstants;

/**
 * This class holds static constants that are used for property names and other such stuff.
 */
public final class SolrConstants {

  /**
   * The execution mode.
   */
  public enum ExecutionMode {
    /**
     * Add.
     */
    ADD,
    /**
     * Delete.
     */
    DELETE,
    /**
     * Update, treated the same as {@link #ADD}.
     */
    UPDATE
  }

  /**
   * Source/Target type AttributeOrAttachment.
   * 
   * @author pwissel
   * 
   */
  public enum AttributeOrAttachment {
    /**
     * Attribute.
     */
    ATTRIBUTE,
    /**
     * Attachment.
     */
    ATTACHMENT;
  }

  /**
   * The parameter execution mode.
   */
  public static final String EXECUTION_MODE = "ExecutionMode";

  /**
   * The parameter core name.
   */
  public static final String CORE_NAME = "CoreName";

  /**
   * The parameter index fields.
   */
  public static final String CORE_FIELDS = "CoreFields";

  /**
   * The parameter field name.
   */
  public static final String CORE_FIELD_NAME = "FieldName";

  /**
   * Record source name.
   */
  public static final String SOURCE_NAME = "RecSourceName";

  /**
   * Record source type (AttributeOrAttachment).
   */
  public static final String SOURCE_TYPE = "RecSourceType";

  /**
   * The core field id.
   */
  public static final String CORE_FIELD_ID = "_recordid";

  /**
   * The core field score.
   */
  public static final String CORE_FIELD_SCORE = "score";

  /**
   * The default solr date format pattern.
   */
  public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";

  /**
   * controls what type of faceting shall be done. one of: facet.field (default), facet.date, facet.range, or any other
   * that solr supports in the future. The value is taken as given and passed as a param to solr with the value
   * contained in the attribute-Val.
   */
  public static final String FACET_TYPE = "type";

  /**
   * The facet query attribute.
   * 
   * @deprecated as of 1.0
   */
  @Deprecated
  public static final String FACET_QUERY_ATTR = "_fc";

  /**
   * The shards.
   */
  public static final String SHARDS = "shards";

  /**
   * annotation name for defining a boost factor (double) of a record/document.
   * <p/>
   * Note: i was thinking if smila defines smth. like this already, as it is a common thing such as _id, but it doesnt
   * make sense to put this @ the record like {@link Record#RECORD_ID} since boosting is search specific. So what we
   * need is a place for constants that make sense in the realm of search but have to do with the indexing side of
   * things, which is the resason why {@link QueryConstants} is not such a good place. AFAIK there is no such place so
   * far.
   */
  public static final String DOC_BOOST = "_docBoost";

  /**
   * Parameter _solr.
   */
  public static final String SOLR_PREFIX = "_solr.";

  /**
   * Parameter query map.
   */
  public static final String QUERY_MAP = SOLR_PREFIX + "query";

  /**
   * Parameter result map.
   */
  public static final String RESULT_MAP = SOLR_PREFIX + "result";

  /**
   * Parameter global.
   */
  public static final String GLOBAL = "global.solr.params";

  /**
   * The parameter field prefix.
   */
  public static final String FIELD_PREFIX = "f.";

  /**
   * The paramter field suffix.
   */
  public static final String FIELD_SUFFIX = ".";

  /**
   * Parameter max_score.
   */
  public static final String MAX_SCORE = "max_score";

  /**
   * Parameter terms.
   */
  public static final String TERMS = "terms";

  /**
   * Parameter highlighting.
   */
  public static final String HIGHLIGHTING = "highlighting";

  /**
   * Parameter filter query.
   */
  public static final String FILTER_QUERY = "fq";

  /**
   * annotation on a record to control the target index/core dynamically. overrides the pipelet config.
   * 
   * @note it might be a good idea to name this _indexName and thus make this a more general item, that all search
   *       engines could use but then it needs to move to another class. as an alternative: we could support both.
   */
  public static final String DYNAMIC_TARGET_CORE = "_coreName";

  /**
   * The DefaultCore folder.
   */
  public static final String DEFAULT_CORE = "DefaultCore";

  /**
   * Parameter spellcheck.
   */
  public static final String SPELLCHECK = "spellcheck";

  /**
   * Parameter collation.
   */
  public static final String COLLATION = "collation";

  /** MLT_META_MAP_NAME. */
  public static final String MLT_RESULT_META = "_mlt.meta";

  /** MLT_SEQ_NAME. */
  public static final String MLT_RESULT_ITEMS = "_mlt";

  /** MORE_LIKE_THIS. */
  public static final String MORE_LIKE_THIS = "moreLikeThis";

  /** prevent instantiation. */
  private SolrConstants() {
    throw new UnsupportedOperationException();
  }
}
