/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Peter Wissel (brox IT Solutions GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.solr.admin;

import org.eclipse.smila.management.LocatedManagementAgentBase;

/**
 * The SolrAdminAgent class.
 * 
 * @author pwissel
 * 
 */
public class SolrAdminAgent extends LocatedManagementAgentBase {

  /**
   * The jmx category.
   */
  private static final String CATEGORY = "Solr";

  /**
   * The agent name.
   */
  private static final String NAME = "SolrAdmin";

  /**
   * The SolrAdmin.
   */
  private final SolrAdmin _solrAdmin;

  /**
   * Constructor.
   * 
   * @param solrAdmin
   *          the SolrAdmin.
   */
  public SolrAdminAgent(SolrAdmin solrAdmin) {
    _solrAdmin = solrAdmin;
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.management.LocatedManagementAgentBase#getCategory()
   */
  @Override
  protected String getCategory() {
    return CATEGORY;
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.smila.management.LocatedManagementAgentBase#getName()
   */
  @Override
  protected String getName() {
    return NAME;
  }

  /**
   * Execute alias action.
   * 
   * @param coreName
   *          the core name.
   * @param aliasName
   *          the alias name.
   * @return the response message.
   */
  public String alias(final String coreName, final String aliasName) {
    try {
      return _solrAdmin.alias(coreName, aliasName);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute create action.
   * 
   * @param coreName
   *          the core name.
   * @param intanceDir
   *          the instance directory.
   * @param dataDir
   *          the data directory.
   * @return the response message.
   */
  public String create(final String coreName, final String intanceDir, final String dataDir) {
    try {
      return _solrAdmin.create(coreName, intanceDir, dataDir);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute create action.
   * 
   * @param coreName
   *          the core name.
   * @return the response message.
   */
  public String create(String srcCore, String targetCoreName) {
    try {
      return _solrAdmin.create(srcCore, targetCoreName);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute merge action.
   * 
   * @param targetCoreName
   *          the target core name.
   * @param sourceIndexDir1
   *          the first source index directory.
   * @param sourceIndexDir2
   *          the second source index directory.
   * @return the response message.
   */
  public String merge(final String targetCoreName, final String sourceIndexDir1, final String sourceIndexDir2) {
    try {
      return _solrAdmin.merge(targetCoreName, sourceIndexDir1, sourceIndexDir2);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute reload action.
   * 
   * @param coreName
   *          the core name.
   * @return the response message.
   */
  public String reload(final String coreName) {
    try {
      return _solrAdmin.reload(coreName);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute rename action.
   * 
   * @param coreName
   *          the core name.
   * @param newName
   *          the new core name.
   * @return the response message.
   */
  public String rename(final String coreName, final String newName) {
    try {
      return _solrAdmin.rename(coreName, newName);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute status action.
   * 
   * @param coreName
   *          the core name or null (for all cores).
   * @return the response message.
   */
  public String status(final String coreName) {
    try {
      return _solrAdmin.status(coreName);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute unload action.
   * 
   * @param coreName
   *          the core name.
   * @return the response message.
   */
  public String unload(final String coreName) {
    try {
      return _solrAdmin.unload(coreName);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute getCoreNames action.
   * 
   * @return either a list of core names, or an error message.
   */
  public Object getCoreNames() {
    try {
      return _solrAdmin.getCoreNames();
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /**
   * Execute getFieldNames action.
   * 
   * @param coreName
   *          the core name.
   * @return either a list of field names, or an error message.
   */
  public Object getFieldNames(final String coreName) {
    try {
      return _solrAdmin.getFieldNames(coreName);
    } catch (Exception exception) {
      return "Error invoking method: " + exception.getMessage();
    }
  }

  /** clear internal caches after external admin operations. */
  public void clearCoreCaches() {
    _solrAdmin.clearCoreCaches();
  }

  /** remove internal data about the given core because it was removed or changed and the caches should be updated. */
  public void clearCoreCache(String coreName) {
    _solrAdmin.clearCoreCache(coreName);
  }
}
