/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.file.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.eclipse.smila.importing.crawler.file.FileCrawlerService;

/**
 * Default implementation of a FileCrawlerService.
 * 
 * @author stuc07
 * 
 */
public class FileCrawlerServiceImpl implements FileCrawlerService {

  /**
   * {@inheritDoc}
   */
  @Override
  public Collection<File> listFiles(final File directory) {
    final File[] fileList = directory.listFiles((FileFilter) FileFileFilter.FILE);
    if (fileList != null) {
      return Arrays.asList(fileList);
    }
    return new ArrayList<File>();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Collection<File> listDirectories(final File directory) {
    final File[] fileList = directory.listFiles((FileFilter) DirectoryFileFilter.DIRECTORY);
    if (fileList != null) {
      return Arrays.asList(fileList);
    }
    return new ArrayList<File>();
  }
}
