/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/

package org.eclipse.smila.importing.crawler.web;

/** constants used by web crawler and subcomponents: attribute and attachment names, task parameters. */
public final class WebCrawlerConstants {
  /** name of attribute containing the URL of the web resource. */
  public static final String ATTRIBUTE_URL = "http.url";

  /** name of attribute containing the last-modified header reported by the web server (if any). */
  public static final String ATTRIBUTE_LASTMODIFIED = "http.lastModified";

  /** name of attribute containing the content-type of the web resource reported by the web server (if any). */
  public static final String ATTRIBUTE_CONTENTTYPE = "http.contenttype";

  /** name of attribute containing the mimetype of the web resource reported by the web server. (if any). */
  public static final String ATTRIBUTE_MIMETYPE = "http.mimetype";

  /** name of attribute containing the charset of the web resource reported by the web server (if any). */
  public static final String ATTRIBUTE_CHARSET = "http.charset";

  /** name of attribute containing the content-length of the web resource reported by the web server (if any). */
  public static final String ATTRIBUTE_SIZE = "http.size";

  /** name of attachment containing the content of a web resource. */
  public static final String ATTACHMENT_CONTENT = "http.content";

  /** don't create instances. */
  private WebCrawlerConstants() {
    throw new UnsupportedOperationException();
  }
}
