/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this 
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (empolis GmbH) - initial API and implementation
 *               Andreas Weber (Attensity Europe GmbH) - renaming: JobIdHelper -> ImportRunIdHelper
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.impl;

import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.connectivity.framework.State;
import org.eclipse.smila.datamodel.Record;

/**
 * Utility class that creates and sets the import run id.
 */
public final class ImportRunIdHelper {

  /**
   * Private construction to avoid creation of instances.
   */
  private ImportRunIdHelper() {
  }

  /**
   * Set the import run id attribute on the given record, using the importRunId provided in state. If any of the
   * parameters is null or state does not contain a import run id the method does quietly nothing.
   * 
   * @param record
   *          the record
   * @param state
   *          a State object containing an import run id
   */
  public static void setImportRunIdAttribute(final Record record, final State state) {
    if (state != null) {
      setImportRunIdAttribute(record, state.getImportRunId());
    }
  }

  /**
   * Set the given importRunId annotation on the given record. If any of the parameters is null or importRunId is an
   * empty String the method does quietly nothing.
   * 
   * @param record
   *          the record
   * @param importRunId
   *          the id of the import run
   */
  public static void setImportRunIdAttribute(final Record record, final String importRunId) {
    if (record != null && record.getMetadata() != null && importRunId != null && importRunId.trim().length() > 0) {
      record.getMetadata().put(ConnectivityManager.ATTRIBUTE_IMPORT_RUN_ID,
        record.getFactory().createStringValue(importRunId));
    }
  }
}
