/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (empolis GmbH) - initial API and implementation
 **********************************************************************************************************************/
package org.eclipse.smila.processing.bpel.util;

import javax.xml.namespace.QName;

import org.eclipse.smila.processing.WorkflowProcessor;

/**
 * Constants used in BPEL integration.
 * 
 * @author jschumacher
 * 
 */
public final class BpelConstants {

  /**
   * name of WSDL operation of SMILA BPEL processes.
   */
  public static final String OPERATION_NAME = "process";

  /** local name of InvokePipelet extension activity. */
  public static final String TAG_INVOKE_PIPELET = "invokePipelet";

  /** local name of tag for specifying the pipelet class name. */
  public static final String TAG_PIPELET = "pipelet";

  /** local name of tag for specifying the variables to process. */
  public static final String TAG_VARIABLES = "variables";

  /** local name of tag for specifying the pipelet configuration. */
  public static final String TAG_CONFIGURATION = "configuration";

  /** attribute name for specifying the pipelet class name. */
  public static final String ATTR_CLASS = "class";

  /** attribute name for specifying the input variable name. */
  public static final String ATTR_INPUT = "input";

  /** attribute name for specifying the output variable name. */
  public static final String ATTR_OUTPUT = "output";

  /** attribute name for specifying the index variable name. */
  public static final String ATTR_INDEX = "index";

  // constants for BPEL messages at runtime.
  /** Our Namespace. */
  public static final String NAMESPACE_PROCESSOR = WorkflowProcessor.NAMESPACE_PROCESSOR;

  /** WSDL type of processor messages. */
  public static final QName TYPE_PROCESSORMESSAGE = new QName(WorkflowProcessor.NAMESPACE_PROCESSOR,
    "ProcessorMessage");

  /** name of root element of ODE message variables. */
  public static final String NAME_MESSAGE = "message";

  /** name of records part of SMILA ODE messages. */
  public static final String PART_RECORDS = "records";

  /** name of id part of SMILA ODE processor messages. */
  public static final String PART_ID = "id";

  /** name of root element in id part. */
  public static final String NAME_REQID = "ReqId";

  /** BPEL 2.0 namespace. */
  public static final String NAMESPACE_BPEL = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";

  /** local name of <code>&lt;process&gt;</code> element. */
  public static final String TAG_PROCESS = "process";

  /** name of <code>name</code> attribute of process elements. */
  public static final String ATTR_NAME = "name";

  /** local name of <code>&lt;invoke&gt;</code> element. */
  public static final String TAG_INVOKE = "invoke";

  /** name of <code>portType</code> attribute of invoke elements. */
  public static final String ATTR_PORTTYPE = "portType";

  /** name of <code>operation</code> attribute of invoke elements. */
  public static final String ATTR_OPERATION = "operation";

  /** name of <code>partnerLink</code> attribute of invoke elements. */
  public static final String ATTR_PARTNERLINK = "partnerLink";

  /** value of <code>portType</code> attribute (local-name part) for sub-pipeline invokes. */
  public static final String VALUE_PORTTYPE_PIPELINECALL = "ProcessorPortType";

  /** value of <code>operation</code> attribute for sub-pipeline invokes. */
  public static final String VALUE_OPERATION_PIPELINECALL = "process";

  /** prevent instance creation. */
  private BpelConstants() {
    throw new IllegalStateException();
  }
}
