/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.importing;

import org.eclipse.smila.utils.MaybeRecoverableException;

/**
 * Thrown by {@link DeltaService} on error in operations. Can denote that the error condition is "recoverable", i.e. it
 * may make sense for the client to retry the operation later.
 */
public class StateException extends MaybeRecoverableException {

  /** cause it's serializable. */
  private static final long serialVersionUID = 1L;

  /** create instance. */
  public StateException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }

  /** create instance. */
  public StateException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }

  /** create instance. */
  public StateException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** create instance. */
  public StateException(final String message) {
    super(message);
  }

}
