/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (empolis GmbH) - initial API and implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity;

import org.eclipse.smila.utils.MaybeRecoverableException;

/**
 * Exception used by ConnectivityManager. If the {@link #isRecoverable()} flag is <code>true</code> it means that the
 * client can try to retry the operation and/or continue to push data. If the flag is <code>false</code> it means that
 * the client should abort its operation, e.g. a crawler should stop, because will not be able to submit the data
 * anyway, because the destination job is not valid.
 */
public class ConnectivityException extends MaybeRecoverableException {

  /** is serializable. */
  private static final long serialVersionUID = 7477562780407019015L;

  /** Creates a non-recoverable ConnectivityException with message. */
  public ConnectivityException(final String message) {
    super(message, false);
  }

  /** Creates a ConnectivityException with cause. If it's recoverable, depends on the cause. */
  public ConnectivityException(final Throwable cause) {
    super(cause);
  }

  /** Creates a ConnectivityException. If it's recoverable, depends on the cause. */
  public ConnectivityException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** Creates a ConnectivityException with message and recoverable flag. */
  public ConnectivityException(final String message, final boolean recoverable) {
    super(message, recoverable);
  }

  /** Creates a ConnectivityException with message, cause and recoverable flag. */
  public ConnectivityException(final String message, final Throwable cause, final boolean recoverable) {
    super(message, cause, recoverable);
  }

  /** Creates a ConnectivityException with cause and recoverable flag. */
  public ConnectivityException(final Throwable cause, final boolean recoverable) {
    super(cause, recoverable);
  }
}
