/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.worker;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.processing.worker.ProcessingWorker;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class PipelineProcessorWorker
extends ProcessingWorker {
    public static final String WORKER_NAME = "pipelineProcessor";
    public static final String KEY_PIPELINE_NAME = "pipelineName";
    public static final String KEY_PIPELINERUN_BULKSIZE = "pipelineRunBulkSize";
    public static final int DEFAULT_PIPELINERUN_BULKSIZE = 1;
    private WorkflowProcessor _processor;

    public String getName() {
        return WORKER_NAME;
    }

    @Override
    public boolean perform(AnyMap parameters, RecordInput recordInput, RecordOutput recordOutput, TaskContext taskContext) throws Exception {
        long pipelineRunBulkSize = this.getPipelineRunBulkSize(parameters);
        String pipelineName = this.getPipelineName(parameters);
        Record record = null;
        boolean success = false;
        do {
            Blackboard blackboard = this.getBlackboard(taskContext);
            try {
                LinkedHashSet<String> recordIds = new LinkedHashSet<String>();
                int i = 0;
                while ((long)i < pipelineRunBulkSize) {
                    record = recordInput.getRecord();
                    if (record == null) break;
                    this.setTaskParameters(record, parameters);
                    blackboard.setRecord(record);
                    recordIds.add(record.getId());
                    ++i;
                }
                if (recordIds.isEmpty() || taskContext.isCanceled()) continue;
                success |= this.processRecords(blackboard, recordIds, pipelineName, recordOutput, taskContext);
            }
            finally {
                this.cleanupBlackboard(blackboard, taskContext);
            }
        } while (record != null && !taskContext.isCanceled());
        return success;
    }

    private void setTaskParameters(Record record, AnyMap parameters) {
        AnyMap parameterMap = record.getMetadata().getMap("_parameters", true);
        for (Map.Entry parameter : parameters.entrySet()) {
            parameterMap.put((String)parameter.getKey(), (Any)parameter.getValue());
        }
    }

    private boolean processRecords(Blackboard blackboard, Collection<String> recordIds, String pipelineName, RecordOutput recordOutput, TaskContext taskContext) throws Exception {
        try {
            String[] inputIds = recordIds.toArray(new String[recordIds.size()]);
            String[] resultIds = this._processor.process(pipelineName, blackboard, inputIds);
            this.writeResultRecords(blackboard, resultIds, recordOutput, taskContext);
            return true;
        }
        catch (ProcessingException ex) {
            if (ex.isRecoverable()) {
                throw ex;
            }
            taskContext.getLog().warn("Failed to process records " + recordIds + ", skipping them.", (Throwable)ex);
            return false;
        }
    }

    private String getPipelineName(AnyMap parameters) {
        String pipelineName = parameters.getStringValue(KEY_PIPELINE_NAME);
        if (pipelineName == null || pipelineName.isEmpty()) {
            throw new IllegalArgumentException("Pipeline name parameter 'pipelineName' is not set.");
        }
        if (!this._processor.getWorkflowNames().contains(pipelineName)) {
            throw new IllegalArgumentException("Configured pipeline '" + pipelineName + "' doesn't exist.");
        }
        return pipelineName;
    }

    private long getPipelineRunBulkSize(AnyMap parameters) {
        Long pipelineRunBulkSize = parameters.getLongValue(KEY_PIPELINERUN_BULKSIZE);
        if (pipelineRunBulkSize != null && pipelineRunBulkSize > 0L) {
            return pipelineRunBulkSize;
        }
        return 1L;
    }

    public void setProcessor(WorkflowProcessor processor) {
        this._processor = processor;
    }

    public void unsetProcessor(WorkflowProcessor processor) {
        if (this._processor == processor) {
            this._processor = null;
        }
    }
}

