/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.httphandler;

import java.net.MalformedURLException;
import java.util.Collection;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.importing.DeltaException;
import org.eclipse.smila.importing.httphandler.ADeltaHandler;

public class DeltaAdminHandler
extends ADeltaHandler {
    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "DELETE".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        if ("DELETE".equals(method)) {
            return this.clearAllSources();
        }
        return this.getSources(requestUri);
    }

    private Object clearAllSources() throws DeltaException {
        this._deltaService.clearAll();
        return null;
    }

    private AnyMap getSources(String requestUri) throws DeltaException, MalformedURLException {
        AnyMap result = DataFactory.DEFAULT.createAnyMap();
        AnySeq sources = result.getSeq("sources", true);
        Collection<String> sourceIds = this._deltaService.getSourceIds();
        for (String sourceId : sourceIds) {
            AnyMap source = sources.getFactory().createAnyMap();
            sources.add((Object)source);
            source.put("id", sourceId);
            source.put("url", URLCreator.create((String)this.getRequestHost(), (String)requestUri, (String)sourceId).toString());
        }
        return result;
    }
}

