/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.eclipse.smila.solr.server.SolrServers;
import org.eclipse.smila.solr.util.SolrProperties;
import org.eclipse.smila.solr.util.SolrQueryUtils;

public class SolrHttpServers
extends SolrServers {
    private final SolrProperties _properties;

    public SolrHttpServers(SolrProperties properties) {
        this._properties = properties;
    }

    @Override
    public SolrServer getAdminServer() throws SolrServerException {
        try {
            return this.createHttpSolrServer(this.getServerUrl());
        }
        catch (IOException ex) {
            throw new SolrServerException((Throwable)ex);
        }
    }

    @Override
    protected SolrServer createServer(String coreName) throws SolrServerException {
        try {
            String url = this.getServerUrl();
            CommonsHttpSolrServer server = this.createHttpSolrServer(String.valueOf(url) + "/" + coreName);
            this.pingServer(server);
            return server;
        }
        catch (IOException ex) {
            throw new SolrServerException((Throwable)ex);
        }
    }

    private String getServerUrl() {
        return this._properties.getServerUrl();
    }

    private void pingServer(CommonsHttpSolrServer server) throws SolrServerException, IOException {
        SolrPingResponse ping = server.ping();
        if (SolrQueryUtils.responseStatusIsError((SolrResponseBase)ping)) {
            String msg = MessageFormat.format("Cannot ping given server for URL: {0}. Response is: {1} {2}", ping.getRequestUrl(), ping.getStatus(), ping.toString());
            throw new SolrServerException(msg);
        }
    }

    private CommonsHttpSolrServer createHttpSolrServer(String url) throws MalformedURLException {
        CommonsHttpSolrServer server = new CommonsHttpSolrServer(url);
        server.setRequestWriter((RequestWriter)new BinaryRequestWriter());
        return server;
    }
}

