/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.datamodel.impl.DefaultDataFactoryImpl;

public final class AnyUtil {
    public static final AnyMap EMPTY_MAP = DefaultDataFactoryImpl.IMMUTABLE_EMPTY_MAP;

    private AnyUtil() {
    }

    public static Object anyToNative(Any any) {
        if (any.isMap()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String key : ((AnyMap)any).keySet()) {
                map.put(key, AnyUtil.anyToNative((Any)((AnyMap)any).get(key)));
            }
            return map;
        }
        if (any.isSeq()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Any a : any) {
                list.add(AnyUtil.anyToNative(a));
            }
            return list;
        }
        if (any.isString()) {
            return ((Value)any).asString();
        }
        if (any.isLong()) {
            return ((Value)any).asLong();
        }
        if (any.isDouble()) {
            return ((Value)any).asDouble();
        }
        if (any.isBoolean()) {
            return ((Value)any).asBoolean();
        }
        if (any.isDate()) {
            return ((Value)any).asDate();
        }
        if (any.isDateTime()) {
            return ((Value)any).asDateTime();
        }
        return ((Value)any).getObject();
    }

    public static Any objectToAny(Object object) {
        Any value = null;
        if (object instanceof Any) {
            return (Any)object;
        }
        value = object instanceof Map ? AnyUtil.mapToAny((Map)object) : (object instanceof List ? AnyUtil.listToAny((List)object) : AnyUtil.scalarObjectToAny(object));
        return value;
    }

    private static AnySeq listToAny(List<Object> objectList) {
        AnySeq anySeq = null;
        if (objectList != null) {
            anySeq = DataFactory.DEFAULT.createAnySeq();
            for (Object obj : objectList) {
                anySeq.add(AnyUtil.objectToAny(obj));
            }
        }
        return anySeq;
    }

    private static Any scalarObjectToAny(Object obj) {
        return DataFactory.DEFAULT.autoConvertValue(obj);
    }

    private static AnyMap mapToAny(Map<String, Object> map) {
        AnyMap anyMap = null;
        if (map != null) {
            anyMap = DataFactory.DEFAULT.createAnyMap();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                anyMap.put(entry.getKey(), AnyUtil.objectToAny(entry.getValue()));
            }
        }
        return anyMap;
    }

    public static Any saveGet(Any any, String[] path) {
        if (path.length == 0) {
            return DataFactory.DEFAULT.createAnyMap();
        }
        try {
            Any current = any;
            String[] stringArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                current = current.isMap() ? (Any)((AnyMap)current).get(key) : null;
                ++n2;
            }
            if (current == null) {
                return DataFactory.DEFAULT.createStringValue("undef");
            }
            return current;
        }
        catch (Exception exception) {
            return DataFactory.DEFAULT.createStringValue("undef");
        }
    }

    public static AnyMap exceptionToAny(Throwable e) {
        return AnyUtil.exceptionToAny(e, new HashSet<String>());
    }

    private static AnyMap exceptionToAny(Throwable e, Collection<String> visitedLines) {
        AnyMap any = DataFactory.DEFAULT.createAnyMap();
        any.put("type", e.getClass().getName());
        if (e.getMessage() != null) {
            any.put("message", e.getMessage());
        }
        AnySeq st = DataFactory.DEFAULT.createAnySeq();
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stElement = stackTraceElementArray[n2];
            String line = stElement.toString();
            st.add(line);
            if (!visitedLines.add(line)) {
                st.add("...");
                break;
            }
            ++n2;
        }
        any.put("at", st);
        if (e.getCause() != null && e.getCause() != e) {
            any.put("causedBy", AnyUtil.exceptionToAny(e.getCause(), visitedLines));
        }
        return any;
    }
}

