/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file;

import java.io.File;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.crawler.file.FileCrawlerService;
import org.eclipse.smila.importing.crawler.file.FileToRecordConverter;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class FileCrawlerWorker
implements Worker {
    public static final String NAME = "fileCrawler";
    public static final String INPUT_SLOT_DIRS_TO_CRAWL = "directoriesToCrawl";
    public static final String OUTPUT_SLOT_DIRS_TO_CRAWL = "directoriesToCrawl";
    public static final String OUTPUT_SLOT_FILES_TO_CRAWL = "filesToCrawl";
    public static final int MAX_FILES_PER_BULK = 1000;
    protected final Log _log = LogFactory.getLog(this.getClass());
    private final FileToRecordConverter _converter = new FileToRecordConverter(DataFactory.DEFAULT);
    private FileCrawlerService _fileCrawler;

    public void setFileCrawlerService(FileCrawlerService fileCrawler) {
        this._fileCrawler = fileCrawler;
    }

    public void unsetFileCrawlerService(FileCrawlerService fileCrawler) {
        if (this._fileCrawler == fileCrawler) {
            this._fileCrawler = null;
        }
    }

    public void perform(TaskContext taskContext) throws Exception {
        block8: {
            try {
                Inputs inputs = taskContext.getInputs();
                if (inputs.getDataObjectCount("directoriesToCrawl") == 0) {
                    this.crawl(taskContext);
                    break block8;
                }
                RecordInput directoryInput = inputs.getAsRecordInput("directoriesToCrawl");
                Record record = directoryInput.getRecord();
                while (record != null) {
                    try {
                        String dirName = record.getMetadata().getStringValue("file.folder");
                        if (dirName == null || dirName.trim().isEmpty()) {
                            taskContext.getLog().error("Failed to crawl directory. Attribute 'file.folder' of record " + record.getId() + " is null or empty");
                        } else {
                            this.crawl(dirName, taskContext.getOutputs(), record.getSource());
                        }
                    }
                    catch (Exception e) {
                        taskContext.getLog().error("Failed to crawl directory '" + record.getMetadata().getStringValue("file.folder") + "' of record " + record.getId(), (Throwable)e);
                    }
                    record = directoryInput.getRecord();
                }
            }
            catch (Exception e) {
                this._log.error((Object)e);
                throw e;
            }
        }
    }

    public String getName() {
        return NAME;
    }

    private void crawl(TaskContext taskContext) throws Exception {
        AnyMap taskParams = taskContext.getTaskParameters();
        String dataSource = taskParams.getStringValue("dataSource");
        if (dataSource == null || dataSource.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter 'dataSource' of task " + taskContext.getTask().getTaskId() + " is null or empty");
        }
        String dirName = taskParams.getStringValue("rootFolder");
        if (dirName == null || dirName.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter 'rootFolder' of task " + taskContext.getTask().getTaskId() + " is null or empty");
        }
        this.crawl(dirName, taskContext.getOutputs(), dataSource);
    }

    private void crawl(String dirName, Outputs outputs, String dataSource) throws Exception {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("file.folder '" + dirName + "' is not a directory");
        }
        int subDirCount = 0;
        Collection<File> subDirectories = this._fileCrawler.listDirectories(dir);
        for (File subDir : subDirectories) {
            RecordOutput directoryOutput = outputs.getAsRecordOutput("directoriesToCrawl", subDirCount);
            Record directoryRecord = this._converter.dirToRecord(subDir, dataSource);
            directoryOutput.writeRecord(directoryRecord);
            directoryOutput.commit();
            ++subDirCount;
            this._log.debug((Object)("added directory " + subDir.getAbsolutePath()));
        }
        int fileCount = 0;
        int recordOutputIndex = 0;
        RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_FILES_TO_CRAWL, recordOutputIndex);
        Collection<File> files = this._fileCrawler.listFiles(dir);
        for (File file : files) {
            Record fileRecord = this._converter.fileToRecord(file, dataSource, false);
            recordOutput.writeRecord(fileRecord);
            this._log.debug((Object)("added file " + file.getAbsolutePath()));
            if (++fileCount % 1000 != 0) continue;
            recordOutput.commit();
            recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_FILES_TO_CRAWL, ++recordOutputIndex);
        }
        this._log.info((Object)("directory " + dir.getAbsolutePath() + " contained " + fileCount + " files and " + subDirCount + " directories."));
    }
}

