/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskmanager.persistence;

import java.util.Collection;
import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCounter;
import org.eclipse.smila.taskmanager.TaskList;
import org.eclipse.smila.taskmanager.TaskmanagerException;

public interface TaskStorage {
    public void storeTask(Task var1) throws TaskmanagerException;

    public void storeTask(String var1, Task var2) throws TaskmanagerException;

    public void storeInProgressTask(Task var1) throws TaskmanagerException;

    public Task getTask(String var1, String var2, Collection<String> var3) throws TaskmanagerException;

    public Task getInProgressTask(String var1, String var2) throws TaskmanagerException;

    public void deleteTask(String var1, String var2) throws TaskmanagerException;

    public void keepAlive(String var1, String var2) throws TaskmanagerException;

    public void purge(String var1) throws TaskmanagerException;

    public void lockQualifiers(String var1, Collection<String> var2);

    public boolean isLockedQualifier(String var1, String var2) throws TaskmanagerException;

    public Map<String, TaskCounter> getTaskCounters() throws TaskmanagerException;

    public TaskList getTaskList(String var1, String var2, int var3) throws TaskmanagerException;

    public Any getTaskInfo(String var1, String var2, String var3) throws TaskmanagerException;

    public long getFailSafetyLevel();

    public void clear() throws TaskmanagerException;

    public void setMaxNoOfTasksPerHost(long var1);

    public long getMaxNoOfTasksPerHost();

    public Map<String, Integer> getScaleUpCounters() throws TaskmanagerException;

    public void removeTasks(AnyMap var1) throws TaskmanagerException;

    public void createTaskQueue(String var1) throws TaskmanagerException;

    public boolean hasTaskQueue(String var1) throws TaskmanagerException;
}

