/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.JobRunDataProvider;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.JobRunDefinitions;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.persistence.PermanentStorage;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.jobmanager.persistence.RunStorageException;

public class JobRunDataProviderImpl
implements JobRunDataProvider {
    private final Log _log = LogFactory.getLog(this.getClass());
    private DefinitionPersistence _defPersistence;
    private PermanentStorage _permStorage;
    private RunStorage _runStorage;

    @Override
    public AnyMap getJobRunData(String jobName, String jobId) throws JobManagerException {
        return this.getJobRunData(jobName, jobId, false);
    }

    @Override
    public AnyMap getJobRunData(String jobName, String jobId, boolean returnDetails) throws JobManagerException {
        try {
            String jobRunId = this._runStorage.getJobRunId(jobName);
            if (jobId.equals(jobRunId)) {
                return this._runStorage.getJobRunData(jobName, returnDetails);
            }
        }
        catch (RunStorageException ex) {
            this._log.warn((Object)("Error determining live job run data for job '" + jobName + "'. Trying to read from history."), (Throwable)((Object)ex));
        }
        if (this._permStorage.containsJobRun(jobName, jobId)) {
            AnyMap jobRunData = this._permStorage.getJobRunData(jobName, jobId);
            if (!returnDetails && jobRunData != null) {
                jobRunData.remove((Object)"workflowDefinition");
                jobRunData.remove((Object)"bucketDefinitions");
            }
            return jobRunData;
        }
        throw new ConfigNotFoundException("No job run data available for run '" + jobId + "' of job '" + jobName + "'.");
    }

    @Override
    public AnyMap getWorkflowRunData(String jobName, String jobId, String workflowRunId) throws JobManagerException {
        String jobRunId = this._runStorage.getJobRunId(jobName);
        if (jobId.equals(jobRunId)) {
            return this._runStorage.getWorkflowRunData(jobName, workflowRunId);
        }
        throw new ConfigNotFoundException("No workflow run data available for run '" + jobId + "' of job '" + jobName + "'.");
    }

    @Override
    public JobRunInfo getJobRunInfo(String jobName) throws JobManagerException {
        return this._runStorage.getJobRunInfo(jobName);
    }

    @Override
    public Collection<String> getCompletedJobRunIds(String jobName) throws JobManagerException {
        String currentjobRunId = this._runStorage.getJobRunId(jobName);
        Collection<String> completedJobRuns = this._permStorage.getJobRunIds(jobName);
        if (currentjobRunId != null) {
            completedJobRuns.remove(currentjobRunId);
        }
        return completedJobRuns;
    }

    private JobDefinition getJob(String name) throws JobManagerException {
        JobDefinition job = this._defPersistence.getJob(name);
        if (job == null) {
            throw new ConfigNotFoundException("Job '" + name + "' not found.");
        }
        return job;
    }

    private WorkflowDefinition getWorkflow(String name) throws JobManagerException {
        WorkflowDefinition workflow = this._defPersistence.getWorkflow(name);
        if (workflow == null) {
            throw new ConfigNotFoundException("Workflow '" + name + "' not found.");
        }
        return workflow;
    }

    public WorkerDefinition getWorker(String name) throws ConfigNotFoundException {
        WorkerDefinition worker = this._defPersistence.getWorker(name);
        if (worker == null) {
            throw new ConfigNotFoundException("Worker '" + name + "' not found.");
        }
        return worker;
    }

    @Override
    public JobRunDefinitions getJobRunDefinitions(String jobName) throws JobManagerException {
        JobRunDefinitions runDefs = new JobRunDefinitions();
        JobDefinition jobDef = this.getJob(jobName);
        runDefs.setJobDefinition(jobDef);
        WorkflowDefinition workflowDef = this.getWorkflow(jobDef.getWorkflow());
        runDefs.setWorkflowDefinition(workflowDef);
        Collection<String> workflowBuckets = workflowDef.getReferencedBuckets();
        Collection<String> persistentBuckets = this._defPersistence.getBuckets();
        persistentBuckets.retainAll(workflowBuckets);
        for (String bucket : persistentBuckets) {
            BucketDefinition bucketDef = this._defPersistence.getBucket(bucket);
            runDefs.addBucketDefinition(bucketDef);
        }
        return runDefs;
    }

    public void setDefinitionPersistence(DefinitionPersistence defPersistence) {
        this._defPersistence = defPersistence;
    }

    public void unsetDefinitionPersistence(DefinitionPersistence defPersistence) {
        if (this._defPersistence == defPersistence) {
            this._defPersistence = null;
        }
    }

    public void setPermanentStorage(PermanentStorage permStorage) {
        this._permStorage = permStorage;
    }

    public void unsetPermanentStorage(PermanentStorage permStorage) {
        if (this._permStorage == permStorage) {
            this._permStorage = null;
        }
    }

    public void setRunStorage(RunStorage runStorage) {
        this._runStorage = runStorage;
    }

    public void unsetRunStorage(RunStorage runStorage) {
        if (this._runStorage == runStorage) {
            this._runStorage = null;
        }
    }
}

