/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.cmd.task.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.jmx.client.cmd.task.Task;
import org.eclipse.smila.management.jmx.client.config.AttributeType;
import org.eclipse.smila.management.jmx.client.exceptions.JmxInvocationException;
import org.eclipse.smila.management.jmx.client.exceptions.OperationException;
import org.eclipse.smila.management.jmx.client.helpers.JmxConnection;
import org.eclipse.smila.management.jmx.client.helpers.OutWriter;
import org.eclipse.smila.management.jmx.client.helpers.ParameterFormatHelper;

public class AttributeTask
implements Task<AttributeType> {
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public Object execute(AttributeType config, JmxConnection connection, Object globalResult, String[] parameters, Object localResult) throws OperationException {
        Object newLocalResult;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult));
        }
        try {
            newLocalResult = connection.getAttribute(ParameterFormatHelper.format(config.getDomain(), globalResult, parameters, localResult), ParameterFormatHelper.format(config.getKey(), globalResult, parameters, localResult), ParameterFormatHelper.format(config.getName(), globalResult, parameters, localResult));
        }
        catch (JmxInvocationException e) {
            throw new OperationException(e);
        }
        OutWriter.write(ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult), newLocalResult, this._log);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"JMX attribute successfully invoked");
        }
        return newLocalResult;
    }
}

