/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ipc.bon;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.eclipse.smila.ipc.bon.BinaryToken;

public final class ValueTrafo {
    private static final String DEFAULT_STRING_ENCODING = "utf-8";
    private static final int BYTE_LENGTH = 8;
    private static final int BYTE_FF = 255;
    private static final int MAX_LONG_BYTE_ARRAY_LENGTH = 8;
    private static final int MAX_INT_BYTE_ARRAY_LENGTH = 4;

    private ValueTrafo() {
    }

    public static long byte2long(byte[] b) {
        long result = 0L;
        int len = b.length;
        if (len > 8) {
            throw new IllegalArgumentException("byte array length must be <= 8; length=" + len);
        }
        int i = len - 1;
        while (i >= 0) {
            long currentByte = b[i] & 0xFF;
            result += currentByte << 8 * (len - 1 - i);
            --i;
        }
        return result;
    }

    public static int byte2int(byte[] b) {
        int result = 0;
        int len = b.length;
        if (len > 4) {
            throw new IllegalArgumentException("byte array length must be <= 4; length=" + len);
        }
        int i = len - 1;
        while (i >= 0) {
            int currentByte = b[i] & 0xFF;
            result += currentByte << 8 * (len - 1 - i);
            --i;
        }
        return result;
    }

    public static byte[] long2byte(long v, int byteLength) {
        if (v < 0L) {
            throw new IllegalArgumentException("value must be > 0");
        }
        byte[] b = ValueTrafo.getBytes(v, byteLength);
        return b;
    }

    public static byte[] long2byte(long v) {
        int size = ValueTrafo.getBytesLength(v);
        return ValueTrafo.long2byte(v, size);
    }

    private static byte[] getBytes(long v, int size) {
        byte[] b = new byte[size];
        int i = size - 1;
        while (i >= 0) {
            b[i] = (byte)(v & 0xFFL);
            v >>= 8;
            --i;
        }
        return b;
    }

    public static int getBytesLength(long v) {
        long tmp = v;
        int size = 0;
        do {
            ++size;
        } while ((tmp >>= 8) != 0L);
        return size;
    }

    public static double byte2double(byte[] b) {
        return ByteBuffer.wrap(b).getDouble();
    }

    public static String byte2string(byte[] b) {
        return new String(b, Charset.forName(DEFAULT_STRING_ENCODING));
    }

    public static byte[] double2byte(double d) {
        ByteBuffer bb = ByteBuffer.allocate(BinaryToken.SCALAR_DOUBLE.valueLength());
        bb.putDouble(d);
        return bb.array();
    }

    public static byte[] string2byte(String s) {
        String cleanString = s.replace('\u0000', ' ');
        return cleanString.getBytes(Charset.forName(DEFAULT_STRING_ENCODING));
    }
}

