/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.persistence.objectstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkflowDefinition;
import org.eclipse.smila.jobmanager.exceptions.PersistenceException;
import org.eclipse.smila.jobmanager.persistence.PermanentStorage;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.ServiceUnavailableException;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.StoreOutputStream;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.osgi.service.component.ComponentContext;

public class PermanentStorageObjectstore
implements PermanentStorage {
    private static final String JOBMANAGER_STORE = "jobmanager";
    private static final String BUCKETS_PREFIX = "buckets/";
    private static final String JOBS_PREFIX = "jobs/";
    private static final String WORKFLOWS_PREFIX = "workflows/";
    private static final String JOB_RUNS_PREFIX = "runs/";
    private static final int MAX_RETRY_ON_STORE_UNAVAILABLE = 3;
    private final Log _log = LogFactory.getLog(this.getClass());
    private ObjectStoreService _objectStoreService;
    private final IpcRecordReader _recordReader = new IpcRecordReader();
    private final IpcAnyWriter _anyWriter = new IpcAnyWriter(true);
    private boolean _isStorePrepared;

    protected void activate(ComponentContext context) throws ObjectStoreException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"activate");
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"deactivate");
        }
    }

    public void setObjectStoreService(ObjectStoreService objectStoreService) {
        this._objectStoreService = objectStoreService;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStoreService) {
        if (this._objectStoreService == objectStoreService) {
            this._objectStoreService = null;
        }
    }

    public void addBucket(BucketDefinition bucket) throws PersistenceException {
        try {
            String objectId = BUCKETS_PREFIX + bucket.getName();
            AnyMap bucketAny = bucket.toAny();
            this.writeObjectToStore(objectId, bucketAny);
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error adding bucket", bucket.getName(), e), (Throwable)e);
        }
    }

    public BucketDefinition getBucket(String name) throws PersistenceException {
        block3: {
            try {
                if (this.existsObjectInStore(BUCKETS_PREFIX + name)) break block3;
                return null;
            }
            catch (Exception e) {
                throw new PersistenceException(this.buildMessage("Error getting bucket", name, e), (Throwable)e);
            }
        }
        String objectId = BUCKETS_PREFIX + name;
        AnyMap bucketAny = this.readObjectFromStore(objectId);
        return new BucketDefinition(bucketAny);
    }

    public void removeBucket(String name) throws PersistenceException {
        try {
            this.removeObjectFromStore(BUCKETS_PREFIX + name);
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error deleting bucket", name, e), (Throwable)e);
        }
    }

    public Collection<String> getBuckets() throws PersistenceException {
        try {
            Collection<String> bucketNames = this.readObjectNamesFromStore(BUCKETS_PREFIX);
            return bucketNames;
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error getting buckets", null, e), (Throwable)e);
        }
    }

    public void addJob(JobDefinition job) throws PersistenceException {
        try {
            String objectId = JOBS_PREFIX + job.getName();
            AnyMap jobAny = job.toAny();
            this.writeObjectToStore(objectId, jobAny);
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error adding job", job.getName(), e), (Throwable)e);
        }
    }

    public JobDefinition getJob(String name) throws PersistenceException {
        if (!this.hasJob(name)) {
            return null;
        }
        try {
            String objectId = JOBS_PREFIX + name;
            AnyMap jobAny = this.readObjectFromStore(objectId);
            return new JobDefinition(jobAny);
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error getting job", name, e), (Throwable)e);
        }
    }

    public boolean hasJob(String name) throws PersistenceException {
        try {
            return this.existsObjectInStore(JOBS_PREFIX + name);
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error checking job", name, e), (Throwable)e);
        }
    }

    public void removeJob(String name) throws PersistenceException {
        try {
            this.removeObjectFromStore(JOBS_PREFIX + name);
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error deleting job", name, e), (Throwable)e);
        }
    }

    public Collection<String> getJobs() throws PersistenceException {
        try {
            Collection<String> jobNames = this.readObjectNamesFromStore(JOBS_PREFIX);
            return jobNames;
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error getting jobs", null, e), (Throwable)e);
        }
    }

    public void addWorkflow(WorkflowDefinition workflow) throws PersistenceException {
        try {
            String objectId = WORKFLOWS_PREFIX + workflow.getName();
            AnyMap workflowAny = workflow.toAny();
            this.writeObjectToStore(objectId, workflowAny);
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error adding workflow", workflow.getName(), e), (Throwable)e);
        }
    }

    public WorkflowDefinition getWorkflow(String name) throws PersistenceException {
        block3: {
            try {
                if (this.existsObjectInStore(WORKFLOWS_PREFIX + name)) break block3;
                return null;
            }
            catch (Exception e) {
                throw new PersistenceException(this.buildMessage("Error getting workflow", name, e), (Throwable)e);
            }
        }
        String objectId = WORKFLOWS_PREFIX + name;
        AnyMap workflowAny = this.readObjectFromStore(objectId);
        return new WorkflowDefinition(workflowAny);
    }

    public Collection<String> getWorkflows() throws PersistenceException {
        try {
            Collection<String> workflowNames = this.readObjectNamesFromStore(WORKFLOWS_PREFIX);
            return workflowNames;
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error getting workflows", null, e), (Throwable)e);
        }
    }

    public void removeWorkflow(String name) throws PersistenceException {
        try {
            this.removeObjectFromStore(WORKFLOWS_PREFIX + name);
        }
        catch (Exception e) {
            throw new PersistenceException(this.buildMessage("Error deleting workflow", name, e), (Throwable)e);
        }
    }

    public Collection<String> getJobRunIds(String jobName) throws PersistenceException {
        try {
            String prefix = this.getJobRunDirectory(jobName);
            Collection<String> jobRunIds = this.readObjectNamesFromStore(prefix);
            return jobRunIds;
        }
        catch (Exception ex) {
            throw new PersistenceException(this.buildMessage("Error reading job run Ids from ObjectStore for job", jobName, ex), (Throwable)ex);
        }
    }

    public void storeJobRun(String jobName, String jobRunId, AnyMap jobRunData) {
        String objectId = this.getJobRunDataName(jobName, jobRunId);
        try {
            if (this._log.isInfoEnabled()) {
                String jsonData;
                try {
                    jsonData = this._anyWriter.writeJsonObject((Any)jobRunData);
                }
                catch (IOException iOException) {
                    jsonData = jobRunData.toString();
                }
                this._log.info((Object)("Job run data of run '" + jobRunId + "' for job '" + jobName + "': " + jsonData));
            }
            this.writeObjectToStore(objectId, jobRunData);
        }
        catch (Exception ex) {
            this._log.error((Object)("Failed to store job run data of run '" + jobRunId + "' for job '" + jobName + "'"), (Throwable)ex);
        }
    }

    public boolean containsJobRun(String jobName, String jobRunId) throws PersistenceException {
        String path = this.getJobRunDataName(jobName, jobRunId);
        try {
            return this.existsObjectInStore(path);
        }
        catch (Exception ex) {
            throw new PersistenceException(this.buildMessage("Error checking existence of run '" + jobRunId + "' for job", jobName, ex), (Throwable)ex);
        }
    }

    public AnyMap getJobRunData(String jobName, String jobRunId) throws PersistenceException {
        String objectId;
        block3: {
            objectId = this.getJobRunDataName(jobName, jobRunId);
            try {
                if (this.existsObjectInStore(objectId)) break block3;
                return null;
            }
            catch (Exception ex) {
                throw new PersistenceException(this.buildMessage("Error getting data for job run '" + jobRunId + "' of job", jobName, ex), (Throwable)ex);
            }
        }
        return this.readObjectFromStore(objectId);
    }

    public void deleteJobRunData(String jobName, String jobRunId) throws PersistenceException {
        String path = this.getJobRunDataName(jobName, jobRunId);
        try {
            this.removeObjectFromStore(path);
        }
        catch (Exception ex) {
            throw new PersistenceException(this.buildMessage("Error deleting data for job run '" + jobRunId + "' of job", jobName, ex), (Throwable)ex);
        }
    }

    private String getJobRunDirectory(String jobName) {
        return JOB_RUNS_PREFIX + jobName + '/';
    }

    private String getJobRunDataName(String jobName, String jobRunId) {
        return String.valueOf(this.getJobRunDirectory(jobName)) + jobRunId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStore() throws ObjectStoreException {
        if (!this._isStorePrepared) {
            try {
                PermanentStorageObjectstore permanentStorageObjectstore = this;
                synchronized (permanentStorageObjectstore) {
                    ObjectStoreRetryUtil.retryEnsureStore((ObjectStoreService)this._objectStoreService, (String)JOBMANAGER_STORE);
                    this._isStorePrepared = true;
                }
            }
            catch (ServiceUnavailableException ex) {
                throw new ServiceUnavailableException(this.buildMessage("Finally failed to prepare store", JOBMANAGER_STORE, (Exception)((Object)ex)), (Throwable)ex);
            }
        }
    }

    private void removeObjectFromStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        this._objectStoreService.removeObject(JOBMANAGER_STORE, objectId);
    }

    private boolean existsObjectInStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        return ObjectStoreRetryUtil.retryExistsObject((ObjectStoreService)this._objectStoreService, (String)JOBMANAGER_STORE, (String)objectId);
    }

    /*
     * Loose catch block
     */
    private void writeObjectToStore(String objectId, AnyMap object) throws ObjectStoreException {
        Throwable retryableEx = null;
        this.ensureStore();
        int i = 0;
        while (i < 3) {
            StoreOutputStream storeOutputStream = null;
            try {
                storeOutputStream = this._objectStoreService.writeObject(JOBMANAGER_STORE, objectId);
                this._anyWriter.writeJsonStream((Any)object, (OutputStream)storeOutputStream);
            }
            catch (IOException ex) {
                if (storeOutputStream != null) {
                    storeOutputStream.abort();
                }
                retryableEx = ex;
                this._log.warn((Object)("IOException on writing object '" + objectId + "', retrying: " + ex.toString()));
                IOUtils.closeQuietly((OutputStream)storeOutputStream);
            }
            catch (ServiceUnavailableException ex2) {
                retryableEx = ex2;
                this._log.warn((Object)("ServiceUnavailableException on writing object '" + objectId + "', retrying: " + ex2.toString()));
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(storeOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)storeOutputStream);
            }
            IOUtils.closeQuietly((OutputStream)storeOutputStream);
            return;
            ++i;
        }
        throw new ServiceUnavailableException(this.buildMessage("Finally failed to write object", objectId, (Exception)retryableEx), retryableEx);
    }

    private AnyMap readObjectFromStore(String objectId) throws ObjectStoreException {
        this.ensureStore();
        Throwable retryableEx = null;
        int i = 0;
        while (i < 3) {
            block7: {
                AnyMap anyMap;
                InputStream jobJsonStream = null;
                try {
                    jobJsonStream = this._objectStoreService.readObject(JOBMANAGER_STORE, objectId);
                    anyMap = this._recordReader.readJsonStream(jobJsonStream).getMetadata();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly(jobJsonStream);
                        throw throwable;
                    }
                    catch (IOException ex) {
                        retryableEx = ex;
                        this._log.warn((Object)("IOException on writing object '" + objectId + "', retrying: " + ex.toString()));
                        break block7;
                    }
                    catch (ServiceUnavailableException ex) {
                        retryableEx = ex;
                        this._log.warn((Object)("ServiceUnavailableException on writing object '" + objectId + "', retrying: " + ex.toString()));
                    }
                }
                IOUtils.closeQuietly((InputStream)jobJsonStream);
                return anyMap;
            }
            ++i;
        }
        throw new ServiceUnavailableException(this.buildMessage("Finally failed to read object", objectId, (Exception)retryableEx), retryableEx);
    }

    private Collection<String> readObjectNamesFromStore(String prefix) throws ObjectStoreException {
        this.ensureStore();
        TreeSet<String> objectNames = new TreeSet<String>();
        for (StoreObject info : this._objectStoreService.getStoreObjectInfos(JOBMANAGER_STORE, prefix)) {
            String objectName = info.getId().substring(prefix.length());
            objectNames.add(objectName);
        }
        return objectNames;
    }

    private String buildMessage(String prefix, String objectName, Exception ex) {
        StringBuilder message = new StringBuilder(prefix);
        if (objectName != null) {
            message.append(" '").append(objectName).append("'");
        }
        message.append(" due to ").append(ex.getClass().getSimpleName());
        message.append(": ").append(ex.getMessage());
        return message.toString();
    }
}

