/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.objectstore.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.objectstore.InvalidStoreNameException;
import org.eclipse.smila.objectstore.NoSuchObjectException;
import org.eclipse.smila.objectstore.NoSuchStoreException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.StoreExistsException;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.StoreOutputStream;
import org.eclipse.smila.objectstore.filesystem.SimpleObjectInfo;
import org.eclipse.smila.objectstore.filesystem.SimpleStoreOutputStream;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.config.ConfigurationLoadException;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.osgi.service.component.ComponentContext;

public class SimpleObjectStoreService
implements ObjectStoreService {
    public static final String VALID_STORENAME_EXPRESSION = "[a-zA-Z0-9-]{0,256}";
    public static final String BUNDLE_ID = "org.eclipse.smila.objectstore.filesystem";
    public static final String PROPERTY_ROOT_PATH = "root.path";
    public static final String PROPERTY_FILE_LOCKING = "file.locking";
    static final ConcurrentHashMap<File, AtomicInteger> LOCK_MAP = new ConcurrentHashMap();
    private static final String PATH_SEPERATOR = "/";
    private static final Pattern VALID_STORENAME_PATTERN = Pattern.compile("[a-zA-Z0-9-]{0,256}");
    private static final String SHADOW_FILE_SUFFIX = ".~shadow-file~";
    private File _rootStorePath;
    private File _visibleStorePath;
    private boolean _fileLockingRequested;
    private final Log _log = LogFactory.getLog(this.getClass());

    /*
     * Unable to fully structure code
     */
    protected void activate(ComponentContext context) throws IOException {
        block14: {
            this._rootStorePath = WorkspaceHelper.createWorkingDir((String)"org.eclipse.smila.objectstore.filesystem");
            configFileStream = null;
            try {
                configFile = ConfigUtils.getConfigFile((String)"org.eclipse.smila.objectstore.filesystem", (String)"objectstoreservice.properties");
                if (configFile != null && configFile.exists()) {
                    configFileStream = new BufferedInputStream(new FileInputStream(configFile));
                    props = new Properties();
                    props.load(configFileStream);
                    storeRootPath = props.getProperty("root.path");
                    if (storeRootPath != null && !"".equals(storeRootPath)) {
                        this._rootStorePath = new File(storeRootPath);
                    }
                    if ((fileLockingRequest = props.getProperty("file.locking")) != null) {
                        this.setFileLockingRequested(Boolean.parseBoolean(fileLockingRequest));
                    }
                } else {
                    this._log.info((Object)"No object store properties found.");
                }
            }
            catch (IOException v0) {
                this._log.warn((Object)("Could not load object store properties. Defaulting store root to '" + this._rootStorePath.getCanonicalPath() + "'."));
                if (configFileStream != null) {
                    IOUtils.closeQuietly((InputStream)configFileStream);
                }
                break block14;
            }
            catch (ConfigurationLoadException v1) {
                try {
                    this._log.warn((Object)("Could not load object store properties. Defaulting store root to '" + this._rootStorePath.getCanonicalPath() + "'."));
                    ** if (configFileStream == null) goto lbl-1000
                }
                catch (Throwable var7_7) {
                    if (configFileStream != null) {
                        IOUtils.closeQuietly(configFileStream);
                    }
                    throw var7_7;
                }
lbl-1000:
                // 1 sources

                {
                    IOUtils.closeQuietly((InputStream)configFileStream);
                }
lbl-1000:
                // 2 sources

                {
                    break block14;
                }
            }
            if (configFileStream == null) break block14;
            IOUtils.closeQuietly(configFileStream);
        }
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Setting objectstore root to '" + this._rootStorePath.getCanonicalPath() + "'."));
        }
        this._visibleStorePath = new File(this._rootStorePath, "objectstore");
    }

    public Collection<String> getStoreNames() throws ObjectStoreException {
        ArrayList<String> storeNames = new ArrayList<String>();
        File[] files = this._visibleStorePath.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    storeNames.add(file.getName());
                }
                ++n2;
            }
        }
        return storeNames;
    }

    public void ensureStore(String storeName) throws ObjectStoreException {
        this.validateStoreName(storeName);
        File store = new File(this._visibleStorePath, storeName);
        if (store.isDirectory()) {
            return;
        }
        if (!store.mkdirs()) {
            throw new ObjectStoreException("Cannot create store '" + storeName + "'.");
        }
    }

    public synchronized boolean isValidStoreName(String storeName) {
        return VALID_STORENAME_PATTERN.matcher(storeName).matches();
    }

    public void createStore(String storeName, AnyMap storeProperties) throws ObjectStoreException {
        this.validateStoreName(storeName);
        File store = new File(this._visibleStorePath, storeName);
        if (store.exists()) {
            throw new StoreExistsException("Store with name '" + storeName + "' already exists.");
        }
        if (!store.mkdirs()) {
            throw new ObjectStoreException("Cannot create store with name '" + storeName + "'.");
        }
    }

    public AnyMap getStoreProperties(String storeName) throws ObjectStoreException {
        return DataFactory.DEFAULT.createAnyMap();
    }

    public AnyMap getStoreInfo(String storeName, boolean includeObjectInfos) throws ObjectStoreException {
        this.validateStore(storeName);
        AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
        File store = new File(this._visibleStorePath, storeName);
        anyMap.put("storeName", storeName);
        anyMap.put("storeProperties", (Any)this.getStoreProperties(storeName));
        Collection<StoreObject> objectInfoList = this.listObjectInfos(store);
        anyMap.put("objectCount", (Number)objectInfoList.size());
        AnySeq objects = DataFactory.DEFAULT.createAnySeq();
        int size = 0;
        for (StoreObject info : objectInfoList) {
            objects.add((Object)info.toAny());
            size = (int)((long)size + info.getSize());
        }
        anyMap.put("size", (Number)size);
        if (includeObjectInfos) {
            anyMap.put("objects", (Any)objects);
        }
        return anyMap;
    }

    public boolean existsStore(String storeName) throws ObjectStoreException {
        File store = new File(this._visibleStorePath, storeName);
        return store.isDirectory();
    }

    public void removeStore(String storeName) throws ObjectStoreException {
        File store = new File(this._visibleStorePath, storeName);
        if (!store.exists()) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)store);
        }
        catch (IOException e) {
            throw new ObjectStoreException("Cannot delete store '" + storeName + "'.", (Throwable)e);
        }
    }

    public void removeAllStores() throws ObjectStoreException {
        try {
            FileUtils.deleteDirectory((File)this._visibleStorePath);
        }
        catch (IOException e) {
            throw new ObjectStoreException("Cannot remove stores.", (Throwable)e);
        }
    }

    public void clearStore(String storeName) throws ObjectStoreException {
        this.validateStore(storeName);
        File store = new File(this._visibleStorePath, storeName);
        try {
            FileUtils.cleanDirectory((File)store);
        }
        catch (IOException e) {
            throw new ObjectStoreException("Cannot clear store '" + storeName + "'.", (Throwable)e);
        }
    }

    public Collection<StoreObject> getStoreObjectInfos(String storeName) throws ObjectStoreException {
        return this.getStoreObjectInfos(storeName, null);
    }

    public Collection<StoreObject> getStoreObjectInfos(String storeName, String objectIdPrefix) throws ObjectStoreException {
        this.validateStore(storeName);
        File store = new File(this._visibleStorePath, storeName);
        return this.listObjectInfos(store, null, objectIdPrefix);
    }

    public long countStoreObjects(String storeName, String objectIdPrefix) throws ObjectStoreException {
        this.validateStore(storeName);
        File store = new File(this._visibleStorePath, storeName);
        return this.countObjectInfos(store, null, objectIdPrefix);
    }

    public Collection<String> getPrefixes(String storeName, String objectIdPrefix) throws ObjectStoreException {
        this.validateStore(storeName);
        File directory = new File(this._visibleStorePath, storeName);
        ArrayList<String> list = new ArrayList<String>();
        String dirPath = null;
        String filePrefix = null;
        if (objectIdPrefix != null) {
            int index = objectIdPrefix.lastIndexOf(PATH_SEPERATOR);
            if (index > -1) {
                dirPath = objectIdPrefix.substring(0, index + 1);
                if (index + 1 < objectIdPrefix.length()) {
                    filePrefix = objectIdPrefix.substring(index + 1);
                }
            } else {
                filePrefix = objectIdPrefix;
            }
        }
        if (dirPath != null) {
            directory = new File(directory, dirPath);
        } else {
            dirPath = "";
        }
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                boolean isShadowFile;
                File file = fileArray[n2];
                String fileId = file.getName();
                if (file.isDirectory()) {
                    fileId = String.valueOf(fileId) + PATH_SEPERATOR;
                }
                if (!(isShadowFile = file.getName().endsWith(SHADOW_FILE_SUFFIX)) && (filePrefix == null || fileId.startsWith(filePrefix))) {
                    list.add(String.valueOf(dirPath) + fileId);
                }
                ++n2;
            }
        }
        return list;
    }

    public byte[] getObject(String storeName, String objectId) throws ObjectStoreException {
        InputStream is = this.readObject(storeName, objectId);
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new ObjectStoreException("Could not read data from object '" + objectId + "' in store '" + storeName + "'.", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public InputStream readObject(String storeName, String objectId) throws ObjectStoreException {
        this.validateStore(storeName);
        File store = new File(this._visibleStorePath, storeName);
        File object = new File(store, objectId);
        if (!object.exists()) {
            throw new NoSuchObjectException("Object with id '" + objectId + "' does not exist in store '" + storeName + "'.");
        }
        try {
            return FileUtils.openInputStream((File)object);
        }
        catch (IOException e) {
            throw new ObjectStoreException("Cannot read object with id '" + objectId + "' from store '" + storeName + "'.", (Throwable)e);
        }
    }

    public void putObject(String storeName, String objectId, byte[] data) throws ObjectStoreException {
        this.writeToObject(storeName, objectId, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToObject(String storeName, String objectId, byte[] data) throws ObjectStoreException {
        this.validateStore(storeName);
        FileOutputStream os = null;
        try {
            try {
                File store = new File(this._visibleStorePath, storeName);
                File object = new File(store, objectId);
                if (!object.getParentFile().equals(store)) {
                    object.getParentFile().mkdirs();
                }
                object.createNewFile();
                AtomicInteger lock = new AtomicInteger(0);
                boolean written = false;
                do {
                    AtomicInteger currentLock;
                    if ((currentLock = LOCK_MAP.putIfAbsent(object, lock)) == null) {
                        currentLock = lock;
                    }
                    currentLock.incrementAndGet();
                    AtomicInteger atomicInteger = currentLock;
                    synchronized (atomicInteger) {
                        if (LOCK_MAP.get(object) == currentLock) {
                            os = new FileOutputStream(object, true);
                            FileChannel fc = os.getChannel();
                            FileLock fileLock = null;
                            if (this.isFileLockingRequested()) {
                                fileLock = fc.lock();
                            }
                            try {
                                fc.write(ByteBuffer.wrap(data));
                                fc.force(true);
                                written = true;
                            }
                            finally {
                                if (fileLock != null) {
                                    fileLock.release();
                                }
                                fc.close();
                            }
                            if (currentLock.decrementAndGet() <= 0) {
                                LOCK_MAP.remove(object);
                            }
                        }
                    }
                } while (!written);
            }
            catch (FileNotFoundException e) {
                throw new NoSuchObjectException("Object with id '" + objectId + "' does not exist in store '" + storeName + "'.", (Throwable)e);
            }
            catch (IOException e) {
                throw new ObjectStoreException("Cannot write object with id '" + objectId + "' in store '" + storeName + "'.", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (os != null) {
                IOUtils.closeQuietly(os);
            }
            throw throwable;
        }
        if (os != null) {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public boolean existsObject(String storeName, String objectId) throws ObjectStoreException {
        File store = new File(this._visibleStorePath, storeName);
        File object = new File(store, objectId);
        return object.exists();
    }

    public void removeObject(String storeName, String objectId) throws ObjectStoreException {
        File store = new File(this._visibleStorePath, storeName);
        File object = new File(store, objectId);
        if (!object.exists()) {
            return;
        }
        if (!object.delete()) {
            throw new ObjectStoreException("Cannot remove object with id '" + objectId + "' from store '" + storeName + "'.");
        }
        SimpleObjectStoreService.removeEmptyParentFolders(object.getParentFile(), store);
    }

    public void removeObjects(String storeName, String objectIdPrefix) throws ObjectStoreException {
        File[] files;
        File dirToDeleteIn;
        if (objectIdPrefix.isEmpty()) {
            this.clearStore(storeName);
            return;
        }
        File store = new File(this._visibleStorePath, storeName);
        int lastSlash = objectIdPrefix.lastIndexOf(PATH_SEPERATOR);
        File file = dirToDeleteIn = lastSlash > 0 ? new File(store, objectIdPrefix.substring(0, lastSlash)) : store;
        if (lastSlash == objectIdPrefix.length() - 1) {
            try {
                FileUtils.deleteDirectory((File)dirToDeleteIn);
                return;
            }
            catch (IOException ex) {
                throw new ObjectStoreException("Could not remove objects with prefix " + objectIdPrefix, (Throwable)ex);
            }
        }
        String filePrefix = lastSlash > 0 ? objectIdPrefix.substring(lastSlash + 1) : objectIdPrefix;
        File[] fileArray = files = dirToDeleteIn.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            if (file2.getName().startsWith(filePrefix)) {
                if (file2.isDirectory()) {
                    try {
                        FileUtils.deleteDirectory((File)file2);
                    }
                    catch (IOException ex) {
                        throw new ObjectStoreException("Could not remove objects with prefix " + objectIdPrefix, (Throwable)ex);
                    }
                } else {
                    file2.delete();
                }
            }
            ++n2;
        }
    }

    public StoreObject getObjectInfo(String storeName, String objectId) throws ObjectStoreException {
        this.validateStore(storeName);
        File store = new File(this._visibleStorePath, storeName);
        File object = new File(store, objectId);
        if (!object.exists()) {
            throw new NoSuchObjectException("Object with id '" + objectId + "' does not exist in store '" + storeName + "'.");
        }
        return new SimpleObjectInfo(object, objectId);
    }

    public void finishObject(String storeName, String objectId) throws ObjectStoreException {
    }

    protected void setFileLockingRequested(boolean fileLocking) {
        this._fileLockingRequested = fileLocking;
    }

    public boolean isFileLockingRequested() {
        return this._fileLockingRequested;
    }

    protected void validateStore(String storeName) throws ObjectStoreException {
        this.validateStoreName(storeName);
        if (!this.existsStore(storeName)) {
            throw new NoSuchStoreException("Store with name '" + storeName + "' does not exist.");
        }
    }

    protected void validateStoreName(String storeName) throws InvalidStoreNameException {
        if (!this.isValidStoreName(storeName)) {
            throw new InvalidStoreNameException("Store name '" + storeName + "' is invalid. Store names must satisfy the following regular expression: '" + VALID_STORENAME_EXPRESSION + "'.");
        }
    }

    protected void writeToObject(String storeName, String objectId, byte[] data) throws ObjectStoreException {
        StoreOutputStream sos = this.writeObject(storeName, objectId);
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)sos);
        try {
            try {
                bos.write(data);
                bos.close();
            }
            catch (IOException e) {
                sos.abort();
                throw new ObjectStoreException("Cannot store object with id '" + objectId + "' in store '" + storeName + "'.", (Throwable)e);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bos);
        }
    }

    public StoreOutputStream writeObject(String storeName, String objectId) throws ObjectStoreException {
        this.validateStore(storeName);
        try {
            File store = new File(this._visibleStorePath, storeName);
            File object = new File(store, objectId);
            File shadowFile = new File(store, String.valueOf(objectId) + UUID.randomUUID() + SHADOW_FILE_SUFFIX);
            this.createShadowFile(shadowFile);
            return new SimpleStoreOutputStream(shadowFile, object, this.isFileLockingRequested());
        }
        catch (IOException e) {
            throw new ObjectStoreException("Cannot store object with id '" + objectId + "' in store '" + storeName + "'.", (Throwable)e);
        }
    }

    private void createShadowFile(File shadowFile) throws IOException {
        int retries = 0;
        while (true) {
            try {
                shadowFile.getParentFile().mkdirs();
                shadowFile.createNewFile();
                return;
            }
            catch (IOException e) {
                if (++retries <= 10) continue;
                throw e;
            }
            break;
        }
    }

    private Collection<StoreObject> listObjectInfos(File directory) {
        return this.listObjectInfos(directory, null, null);
    }

    private Collection<StoreObject> listObjectInfos(File directory, String path, String idPrefix) {
        File[] fileList;
        String dirPath;
        String string = dirPath = path == null ? "" : String.valueOf(path) + PATH_SEPERATOR;
        if (directory.isDirectory() && (fileList = directory.listFiles()) != null) {
            return this.listObjectInfos(dirPath, idPrefix, fileList);
        }
        return Collections.emptyList();
    }

    private Collection<StoreObject> listObjectInfos(String dirPath, String idPrefix, File[] fileList) {
        ArrayList<StoreObject> list = new ArrayList<StoreObject>();
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileId = String.valueOf(dirPath) + file.getName();
            boolean isShadowFile = file.getName().endsWith(SHADOW_FILE_SUFFIX);
            if (file.isFile() && !isShadowFile) {
                if (idPrefix == null || fileId.startsWith(idPrefix)) {
                    list.add(new SimpleObjectInfo(file, fileId));
                }
            } else if (file.isDirectory() && (idPrefix == null || fileId.startsWith(idPrefix) || idPrefix.startsWith(fileId))) {
                list.addAll(this.listObjectInfos(file, fileId, idPrefix));
            }
            ++n2;
        }
        return list;
    }

    private long countObjectInfos(File directory, String path, String idPrefix) {
        File[] fileList;
        String dirPath;
        String string = dirPath = path == null ? "" : String.valueOf(path) + PATH_SEPERATOR;
        if (directory.isDirectory() && (fileList = directory.listFiles()) != null) {
            return this.countObjectInfos(dirPath, idPrefix, fileList);
        }
        return 0L;
    }

    private long countObjectInfos(String dirPath, String idPrefix, File[] fileList) {
        long count = 0L;
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileId = String.valueOf(dirPath) + file.getName();
            boolean isShadowFile = file.getName().endsWith(SHADOW_FILE_SUFFIX);
            if (file.isFile() && !isShadowFile) {
                if (idPrefix == null || fileId.startsWith(idPrefix)) {
                    ++count;
                }
            } else if (file.isDirectory() && (idPrefix == null || fileId.startsWith(idPrefix) || idPrefix.startsWith(fileId))) {
                count += this.countObjectInfos(file, fileId, idPrefix);
            }
            ++n2;
        }
        return count;
    }

    static void removeEmptyParentFolders(File folder, File rootFolder) {
        File actual = folder;
        while (actual != null && !actual.equals(rootFolder)) {
            if (!actual.delete()) {
                return;
            }
            actual = actual.getParentFile();
        }
    }
}

