/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.objectstore.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.objectstore.StoreOutputStream;
import org.eclipse.smila.objectstore.filesystem.SimpleObjectStoreService;

public class SimpleStoreOutputStream
extends StoreOutputStream {
    private boolean _closed;
    private final FileOutputStream _os;
    private final File _tempFile;
    private final File _finalFile;
    private final boolean _fileLockingRequested;

    public SimpleStoreOutputStream(File tempFile, File finalFile, boolean fileLocking) throws FileNotFoundException {
        this._tempFile = tempFile;
        this._finalFile = finalFile;
        this._os = new FileOutputStream(this._tempFile);
        this._fileLockingRequested = fileLocking;
    }

    public void abort() {
        IOUtils.closeQuietly((OutputStream)this._os);
        FileUtils.deleteQuietly((File)this._tempFile);
        this._closed = true;
    }

    public void write(int b) throws IOException {
        this._os.write(b);
    }

    public void write(byte[] b) throws IOException {
        this._os.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._os.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this._closed) {
                return;
            }
            this._os.close();
            AtomicInteger lock = new AtomicInteger(0);
            boolean written = false;
            do {
                AtomicInteger currentLock;
                if ((currentLock = SimpleObjectStoreService.LOCK_MAP.putIfAbsent(this._finalFile, lock)) == null) {
                    currentLock = lock;
                }
                currentLock.incrementAndGet();
                AtomicInteger atomicInteger = currentLock;
                synchronized (atomicInteger) {
                    if (SimpleObjectStoreService.LOCK_MAP.get(this._finalFile) == currentLock) {
                        written = this.makeFileVisible();
                        if (currentLock.decrementAndGet() <= 0) {
                            SimpleObjectStoreService.LOCK_MAP.remove(this._finalFile);
                        }
                    }
                }
            } while (!written);
        }
        finally {
            FileUtils.deleteQuietly((File)this._tempFile);
        }
    }

    protected boolean makeFileVisible() throws IOException {
        boolean written;
        FileLock fileLock = null;
        this._finalFile.getParentFile().mkdirs();
        this._finalFile.createNewFile();
        FileOutputStream os = new FileOutputStream(this._finalFile);
        FileChannel fc = os.getChannel();
        if (this._fileLockingRequested) {
            fileLock = fc.lock();
        }
        try {
            FileInputStream is = new FileInputStream(this._tempFile);
            FileChannel ifc = is.getChannel();
            int numOfBytesTransferred = 0;
            long writeByteCount = 0L;
            long fileSize = this._tempFile.length();
            do {
                if ((writeByteCount = ifc.transferTo(0L, fileSize - writeByteCount, fc)) <= 0L) continue;
                numOfBytesTransferred = (int)((long)numOfBytesTransferred + writeByteCount);
            } while ((long)numOfBytesTransferred < fileSize);
            ifc.close();
            is.close();
            this._closed = true;
            written = true;
        }
        finally {
            if (fileLock != null) {
                fileLock.release();
            }
            if (fc != null) {
                fc.close();
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        return written;
    }

    public void flush() throws IOException {
        this._os.flush();
    }
}

