/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.agent.jobfile;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.AgentCriticalException;
import org.eclipse.smila.connectivity.framework.agent.jobfile.Activator;
import org.eclipse.smila.connectivity.framework.agent.jobfile.JobFileHandler;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.StaxRecordReader;

public class JobFileReader {
    public static final String TAG_JOB_FILE = "JobFile";
    public static final String TAG_ADD = "Add";
    public static final String TAG_DELETE = "Delete";
    private final StaxRecordReader _recordReader;
    private final JobFileHandler _jobFileHandler;
    private final String _attachmentSeparator;
    private final int _attachmentSeparatorLength;
    private final Log _log = LogFactory.getLog(JobFileReader.class);

    public JobFileReader(JobFileHandler jobFileHandler, String attachmentSeparator) {
        this(jobFileHandler, attachmentSeparator, new StaxRecordReader());
    }

    public JobFileReader(JobFileHandler jobFileHandler, String attachmentSeparator, StaxRecordReader recordReader) {
        if (jobFileHandler == null) {
            throw new IllegalArgumentException("parameter jobFileHandler is null");
        }
        if (attachmentSeparator == null) {
            throw new IllegalArgumentException("parameter attachmentSeparator is null");
        }
        if (attachmentSeparator.trim().length() == 0) {
            throw new IllegalArgumentException("parameter attachmentSeparator is an empty String");
        }
        if (recordReader == null) {
            throw new IllegalArgumentException("parameter recordReader is null");
        }
        this._jobFileHandler = jobFileHandler;
        this._recordReader = recordReader;
        this._attachmentSeparator = attachmentSeparator;
        this._attachmentSeparatorLength = this._attachmentSeparator.length();
    }

    public void readJobFile(URL url) throws XMLStreamException {
        if (url == null) {
            throw new IllegalArgumentException("parameter url is null");
        }
        InputStream stream = null;
        try {
            try {
                stream = this.getInputStream(url);
                XMLStreamReader staxReader = Activator.getXMLInputFactory().createXMLStreamReader(stream);
                this.parse(staxReader, url);
            }
            catch (XMLStreamException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Error while loading job file " + url;
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)msg, (Throwable)e);
                }
                throw new XMLStreamException(msg, e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    private void parse(XMLStreamReader staxReader, URL url) throws XMLStreamException, AgentCriticalException {
        staxReader.nextTag();
        if (this.isStartTag(staxReader, TAG_JOB_FILE)) {
            while (staxReader.hasNext()) {
                Record record;
                staxReader.nextTag();
                if (this.isStartTag(staxReader, TAG_ADD)) {
                    staxReader.nextTag();
                    do {
                        if ((record = this._recordReader.readRecord(staxReader)) != null) {
                            try {
                                this.loadAttachments(record);
                                this._jobFileHandler.add(record);
                            }
                            catch (IOException e) {
                                String msg = "Error loading attachments for record " + record.getId() + ". Record is skipped.";
                                this._log.error((Object)msg, (Throwable)e);
                            }
                        }
                        staxReader.nextTag();
                    } while (staxReader.hasNext() && !this.isEndTag(staxReader, TAG_ADD));
                    continue;
                }
                if (this.isStartTag(staxReader, TAG_DELETE)) {
                    staxReader.nextTag();
                    do {
                        record = this._recordReader.readRecord(staxReader);
                        this._jobFileHandler.delete(record);
                        staxReader.nextTag();
                    } while (staxReader.hasNext() && !this.isEndTag(staxReader, TAG_DELETE));
                    continue;
                }
                if (!this.isEndTag(staxReader, TAG_JOB_FILE)) {
                    continue;
                }
                break;
            }
        } else {
            throw new XMLStreamException("Invalid document " + url + ". Must begin with tag <" + TAG_JOB_FILE + ">");
        }
    }

    private boolean isStartTag(XMLStreamReader staxReader, String tagName) {
        return staxReader.isStartElement() && tagName.equals(staxReader.getLocalName());
    }

    private boolean isEndTag(XMLStreamReader staxReader, String tagName) {
        return staxReader.isEndElement() && tagName.equals(staxReader.getLocalName());
    }

    private void loadAttachments(Record record) throws IOException {
        Iterator attachmentNames = record.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            this.loadAttachment(record, (String)attachmentNames.next());
        }
    }

    private void loadAttachment(Record record, String nameUrl) throws IOException {
        if (nameUrl != null) {
            int index = nameUrl.indexOf(this._attachmentSeparator);
            if (index > 0) {
                String attachmentName = nameUrl.substring(0, index);
                String urlString = nameUrl.substring(index + this._attachmentSeparatorLength);
                if (!urlString.startsWith("http") && !urlString.startsWith("file")) {
                    urlString = "file://" + urlString.replaceAll("\\\\", "/");
                }
                record.setAttachment(attachmentName, this.readBytes(new URL(urlString.trim())));
            } else if (this._log.isWarnEnabled()) {
                this._log.warn((Object)("Invalid name pattern for attachment name " + nameUrl + " for record id " + record.getId() + ". Attachment is skipped."));
            }
            record.removeAttachment(nameUrl);
        }
    }

    private InputStream getInputStream(URL url) throws IOException {
        InputStream stream = null;
        if (url != null) {
            if (url.getProtocol().startsWith("file")) {
                stream = new FileInputStream(String.valueOf(url.getAuthority()) + url.getPath());
            } else {
                HttpClient httpClient = new HttpClient();
                GetMethod getMethod = new GetMethod(url.toString());
                httpClient.executeMethod((HttpMethod)getMethod);
                stream = getMethod.getResponseBodyAsStream();
            }
        }
        return stream;
    }

    private byte[] readBytes(URL url) throws IOException {
        InputStream stream = null;
        try {
            stream = this.getInputStream(url);
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }
}

