/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.StoreOutputStream;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.output.Output;
import org.eclipse.smila.taskworker.util.Counters;

public class StreamOutput
extends Output {
    private StoreOutputStream _dosStream;
    private CountingOutputStream _stream;

    public StreamOutput(BulkInfo dataObject, ObjectStoreService objectStore) {
        super(dataObject, objectStore);
    }

    public OutputStream getStream() throws ObjectStoreException {
        if (this._dosStream == null) {
            long start = this.startTime();
            this._dosStream = ObjectStoreRetryUtil.retryWriteObject((ObjectStoreService)this.getObjectStore(), (String)this.getStoreName(), (String)this.getObjectName());
            this._stream = new CountingOutputStream((OutputStream)this._dosStream);
            this.timeOpen(start);
        }
        return this._stream;
    }

    @Override
    public void commit() throws IOException {
        if (this._dosStream != null) {
            ObjectStoreRetryUtil.retryClose((StoreOutputStream)this._dosStream);
            IOUtils.closeQuietly((OutputStream)this._stream);
        }
    }

    public long getBytesWritten() {
        if (this._stream != null) {
            return this._stream.getByteCount();
        }
        return 0L;
    }

    @Override
    public Map<String, Number> getCounter() {
        Map<String, Number> counter = super.getCounter();
        Counters.add(counter, "size", this.getBytesWritten());
        return counter;
    }

    @Override
    public void abort() throws IOException {
        if (this._dosStream != null) {
            this._dosStream.abort();
            ObjectStoreRetryUtil.retryClose((StoreOutputStream)this._dosStream);
            IOUtils.closeQuietly((OutputStream)this._stream);
        }
    }
}

