/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMessageVarType
extends OVarType {
    private static final long serialVersionUID = 256680050844726425L;
    public QName messageType;
    public final Map<String, Part> parts = new LinkedHashMap<String, Part>();
    public final OElementVarType docLitType;

    public OMessageVarType(OProcess oProcess, QName qName, Collection<Part> collection) {
        super(oProcess);
        this.messageType = qName;
        for (Part part : collection) {
            this.parts.put(part.name, part);
        }
        this.docLitType = collection.size() == 1 && collection.iterator().next().type instanceof OElementVarType ? (OElementVarType)collection.iterator().next().type : null;
    }

    boolean isDocLit() {
        return this.docLitType != null;
    }

    @Override
    public Node newInstance(Document document) {
        Element element = document.createElementNS(null, "message");
        for (Part part : this.parts.values()) {
            Element element2 = document.createElementNS(null, part.name);
            element2.appendChild(part.type.newInstance(document));
            element.appendChild(element2);
        }
        return element;
    }

    public static class Part
    extends OBase {
        private static final long serialVersionUID = -2356665271228433779L;
        public String name;
        public OVarType type;

        public Part(OProcess oProcess, String string, OVarType oVarType) {
            super(oProcess);
            this.name = string;
            this.type = oVarType;
        }
    }
}

