/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.rtrep.v2.ACTIVITY;
import org.apache.ode.bpel.rtrep.v2.ActivityInfo;
import org.apache.ode.bpel.rtrep.v2.BpelJacobRunnable;
import org.apache.ode.bpel.rtrep.v2.CompensationHandler;
import org.apache.ode.bpel.rtrep.v2.LinkFrame;
import org.apache.ode.bpel.rtrep.v2.LinkInfo;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.SCOPE;
import org.apache.ode.bpel.rtrep.v2.ScopeFrame;
import org.apache.ode.bpel.rtrep.v2.channels.FaultData;
import org.apache.ode.bpel.rtrep.v2.channels.LinkStatusChannel;
import org.apache.ode.bpel.rtrep.v2.channels.LinkStatusChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannel;
import org.apache.ode.bpel.rtrep.v2.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.rtrep.v2.channels.ReadWriteLockChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TimerResponseChannel;
import org.apache.ode.bpel.rtrep.v2.channels.TimerResponseChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.jacob.SynchChannelListener;
import org.apache.ode.jacob.ValChannel;
import org.apache.ode.jacob.ValChannelListener;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCOPEACT
extends ACTIVITY {
    private static final Log __log = LogFactory.getLog(SCOPEACT.class);
    private static final long serialVersionUID = -4593029783757994939L;

    public SCOPEACT(ActivityInfo activityInfo, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(activityInfo, scopeFrame, linkFrame);
    }

    public void run() {
        if (((OScope)this._self.o).isolatedScope) {
            __log.debug((Object)"found ISOLATED scope, instance ISOLATEDGUARD");
            SCOPEACT.instance((JacobRunnable)new ISOLATEDGUARD(this.createLockList(), (SynchChannel)this.newChannel(SynchChannel.class), this._scopeFrame));
        } else {
            LinkFrame linkFrame;
            ScopeFrame scopeFrame = new ScopeFrame((OScope)this._self.o, this.getBpelRuntime().createScopeInstance(this._scopeFrame.scopeInstanceId, (OScope)this._self.o), this._scopeFrame, null);
            if (((OScope)this._self.o).atomicScope) {
                this.getBpelRuntime().setAtomicScope(true);
                if (!((OScope)this._self.o).inboundMessageChildActivity) {
                    this.getBpelRuntime().forceFlush();
                }
                SCOPEACT.instance((JacobRunnable)new SLEEPER());
                ValChannel valChannel = (ValChannel)this.newChannel(ValChannel.class);
                ParentScopeChannel parentScopeChannel = (ParentScopeChannel)this.newChannel(ParentScopeChannel.class);
                linkFrame = this.createInterceptorLinkFrame();
                if (!this._self.o.outgoingLinks.isEmpty()) {
                    SCOPEACT.instance((JacobRunnable)new LINKSTATUSINTERCEPTOR(valChannel, linkFrame));
                }
                SCOPEACT.instance((JacobRunnable)new UNLOCKER(parentScopeChannel, this._self.parent, null, Collections.<IsolationLock>emptyList(), valChannel));
                this._self.parent = parentScopeChannel;
            } else {
                this.getBpelRuntime().setAtomicScope(false);
                linkFrame = this._linkFrame;
            }
            SCOPEACT.instance((JacobRunnable)new SCOPE(this._self, scopeFrame, linkFrame));
        }
    }

    private List<IsolationLock> createLockList() {
        LinkedList<IsolationLock> linkedList = new LinkedList<IsolationLock>();
        OScope oScope = (OScope)this._self.o;
        HashSet hashSet = new HashSet(oScope.variableRd);
        hashSet.addAll(oScope.variableWr);
        for (OScope.Variable variable : hashSet) {
            linkedList.add(new IsolationLock(variable, oScope.variableWr.contains(variable), this._scopeFrame.globals._varLocks.get(variable)));
        }
        Collections.sort(linkedList);
        return linkedList;
    }

    private LinkFrame createInterceptorLinkFrame() {
        LinkFrame linkFrame = new LinkFrame(this._linkFrame);
        for (OLink oLink : this._self.o.outgoingLinks) {
            LinkInfo linkInfo = this._linkFrame.resolve(oLink);
            LinkStatusChannel linkStatusChannel = (LinkStatusChannel)this.newChannel(LinkStatusChannel.class);
            linkFrame.links.put(linkInfo.olink, new LinkInfo(linkInfo.olink, linkStatusChannel));
        }
        return linkFrame;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsolationLock
    implements Comparable<IsolationLock>,
    Serializable {
        private static final long serialVersionUID = 4214864393241172705L;
        OScope.Variable guardedObject;
        boolean writeLock;
        ReadWriteLockChannel lockChannel;

        public IsolationLock(OScope.Variable variable, boolean bl, ReadWriteLockChannel readWriteLockChannel) {
            this.guardedObject = variable;
            this.writeLock = bl;
            this.lockChannel = readWriteLockChannel;
        }

        @Override
        public int compareTo(IsolationLock isolationLock) {
            return this.guardedObject.getId() - isolationLock.guardedObject.getId();
        }
    }

    private class SLEEPER
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -476393080609348172L;

        public void run() {
            __log.debug((Object)"running SLEEPER");
            if (!this.getBpelRuntime().isFirstTry() && this.getBpelRuntime().isRetryable()) {
                Date date = new Date(new Date().getTime() + (long)(this.getBpelRuntime().getRetryDelay() * 1000));
                TimerResponseChannel timerResponseChannel = (TimerResponseChannel)this.newChannel(TimerResponseChannel.class);
                this.getBpelRuntime().registerTimer(timerResponseChannel, date);
                SLEEPER.object((boolean)false, (ChannelListener)new TimerResponseChannelListener(timerResponseChannel){
                    private static final long serialVersionUID = -261911108068231376L;

                    public void onTimeout() {
                        SLEEPER.this.getBpelRuntime().setRetriedOnce();
                    }

                    public void onCancel() {
                        SLEEPER.this.getBpelRuntime().setRetriesDone();
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UNLOCKER
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -476393080609348172L;
        private final ParentScopeChannel _self;
        private final ParentScopeChannel _parent;
        private final SynchChannel _synchChannel;
        private final List<IsolationLock> _locks;
        private final ValChannel _linkStatusInterceptor;

        public UNLOCKER(ParentScopeChannel parentScopeChannel, ParentScopeChannel parentScopeChannel2, SynchChannel synchChannel, List<IsolationLock> list, ValChannel valChannel) {
            this._self = parentScopeChannel;
            this._parent = parentScopeChannel2;
            this._synchChannel = synchChannel;
            this._locks = list;
            this._linkStatusInterceptor = valChannel;
        }

        public void run() {
            __log.debug((Object)"running UNLOCKER");
            UNLOCKER.object((ChannelListener)new ParentScopeChannelListener(this._self){

                @Override
                public void cancelled() {
                    UNLOCKER.this._parent.cancelled();
                    UNLOCKER.this._linkStatusInterceptor.val((Object)false);
                    UNLOCKER.this.unlockAll(false);
                }

                @Override
                public void compensate(OScope oScope, SynchChannel synchChannel) {
                    UNLOCKER.this._parent.compensate(oScope, synchChannel);
                    1.instance((JacobRunnable)UNLOCKER.this);
                }

                @Override
                public void completed(FaultData faultData, Set<CompensationHandler> set) {
                    if (faultData != null) {
                        if (!UNLOCKER.this.isScopeRetryable()) {
                            FaultData faultData2 = UNLOCKER.this.createFault(SCOPEACT.this.getConstants().qnScopeRollback, faultData.getFaultMessage(), null, SCOPEACT.this._self.o);
                            UNLOCKER.this._parent.completed(faultData2, CompensationHandler.emptySet());
                            UNLOCKER.this._linkStatusInterceptor.val((Object)false);
                            UNLOCKER.this.unlockAll(false);
                        } else {
                            UNLOCKER.this.unlockAll(true);
                        }
                    } else {
                        UNLOCKER.this._parent.completed(faultData, set);
                        UNLOCKER.this._linkStatusInterceptor.val((Object)(faultData == null ? 1 : 0));
                        UNLOCKER.this.unlockAll(false);
                    }
                    UNLOCKER.this.getBpelRuntime().setRetriedOnce();
                }

                @Override
                public void failure(String string, Element element) {
                    UNLOCKER.this.unlockAll(true);
                    if (!UNLOCKER.this.isScopeRetryable()) {
                        FaultData faultData = UNLOCKER.this.createFault(SCOPEACT.this.getConstants().qnScopeRollback, element, null, SCOPEACT.this._self.o);
                        UNLOCKER.this._parent.completed(faultData, CompensationHandler.emptySet());
                        UNLOCKER.this._linkStatusInterceptor.val((Object)false);
                    }
                }
            });
        }

        private void unlockAll(boolean bl) {
            __log.debug((Object)("UNLOCKER: unlockAll: " + this._locks));
            if (((OScope)SCOPEACT.this._self.o).atomicScope) {
                if (bl) {
                    this.getBpelRuntime().forceRollback();
                } else {
                    this.getBpelRuntime().forceFlush();
                }
            }
            for (IsolationLock isolationLock : this._locks) {
                isolationLock.lockChannel.unlock(this._synchChannel);
            }
            this._locks.clear();
        }

        private boolean isScopeRetryable() {
            if (!this.getBpelRuntime().isFirstTry()) {
                return this.getBpelRuntime().isRetryable();
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ISOLATEDGUARD
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -5017579415744600900L;
        final List<IsolationLock> _locksNeeded;
        final LinkedList<IsolationLock> _locksAcquired = new LinkedList();
        final SynchChannel _synchChannel;

        ISOLATEDGUARD(List<IsolationLock> list, SynchChannel synchChannel, ScopeFrame scopeFrame) {
            this._locksNeeded = list;
            this._synchChannel = synchChannel;
            this._scopeFrame = scopeFrame;
        }

        public void run() {
            if (this._locksNeeded.isEmpty()) {
                __log.debug((Object)("ISOLATIONGUARD: got all required locks: " + this._locksAcquired));
                ScopeFrame scopeFrame = new ScopeFrame((OScope)SCOPEACT.this._self.o, this.getBpelRuntime().createScopeInstance(this._scopeFrame.scopeInstanceId, (OScope)SCOPEACT.this._self.o), this._scopeFrame, null);
                ParentScopeChannel parentScopeChannel = SCOPEACT.this._self.parent;
                SCOPEACT.this._self.parent = (ParentScopeChannel)this.newChannel(ParentScopeChannel.class);
                ValChannel valChannel = (ValChannel)this.newChannel(ValChannel.class);
                ISOLATEDGUARD.instance((JacobRunnable)new UNLOCKER(SCOPEACT.this._self.parent, parentScopeChannel, this._synchChannel, this._locksAcquired, valChannel));
                LinkFrame linkFrame = SCOPEACT.this.createInterceptorLinkFrame();
                ISOLATEDGUARD.instance((JacobRunnable)new LINKSTATUSINTERCEPTOR(valChannel, linkFrame));
                ISOLATEDGUARD.instance((JacobRunnable)new SCOPE(SCOPEACT.this._self, scopeFrame, linkFrame));
                return;
            }
            __log.debug((Object)("ISOLATIONGUARD: don't have all locks still need: " + this._locksNeeded));
            IsolationLock isolationLock = this._locksNeeded.get(0);
            if (isolationLock.writeLock) {
                isolationLock.lockChannel.writeLock(this._synchChannel);
            } else {
                isolationLock.lockChannel.readLock(this._synchChannel);
            }
            ISOLATEDGUARD.object((ChannelListener)new SynchChannelListener(this._synchChannel){
                private static final long serialVersionUID = 2857261074409098274L;

                public void ret() {
                    __log.debug((Object)("ISOLATIONGUARD: got lock: " + ISOLATEDGUARD.this._locksNeeded.get(0)));
                    ISOLATEDGUARD.this._locksAcquired.add(ISOLATEDGUARD.this._locksNeeded.remove(0));
                    1.instance((JacobRunnable)ISOLATEDGUARD.this);
                }
            });
        }
    }

    private class LINKSTATUSINTERCEPTOR
    extends BpelJacobRunnable {
        private static final long serialVersionUID = 3104008741240676253L;
        private final ValChannel _self;
        private final LinkFrame _interceptedChannels;
        private final Map<OLink, Boolean> _statuses = new HashMap<OLink, Boolean>();
        private Boolean _status;

        LINKSTATUSINTERCEPTOR(ValChannel valChannel, LinkFrame linkFrame) {
            this._self = valChannel;
            this._interceptedChannels = linkFrame;
        }

        public void run() {
            __log.debug((Object)"LINKSTATUSINTERCEPTOR: running ");
            HashSet<Object> hashSet = new HashSet<Object>();
            if (this._status == null) {
                hashSet.add(new ValChannelListener(this._self){
                    private static final long serialVersionUID = 5029554538593371750L;

                    public void val(Object object) {
                        __log.debug((Object)("LINKSTATUSINTERCEPTOR: status received " + object));
                        LINKSTATUSINTERCEPTOR.this._status = (Boolean)object;
                        for (OLink oLink : LINKSTATUSINTERCEPTOR.this._statuses.keySet()) {
                            SCOPEACT.this._linkFrame.resolve((OLink)oLink).channel.linkStatus((Boolean)LINKSTATUSINTERCEPTOR.this._statuses.get(oLink) != false && LINKSTATUSINTERCEPTOR.this._status != false);
                        }
                        if (!LINKSTATUSINTERCEPTOR.this.isDone()) {
                            1.instance((JacobRunnable)LINKSTATUSINTERCEPTOR.this);
                        }
                    }
                });
            }
            for (final Map.Entry<OLink, LinkInfo> entry : this._interceptedChannels.links.entrySet()) {
                if (this._statuses.containsKey(entry.getKey())) continue;
                hashSet.add(new LinkStatusChannelListener(entry.getValue().channel){
                    private static final long serialVersionUID = 1568144473514091593L;

                    public void linkStatus(boolean bl) {
                        LINKSTATUSINTERCEPTOR.this._statuses.put(entry.getKey(), bl);
                        if (LINKSTATUSINTERCEPTOR.this._status != null) {
                            SCOPEACT.this._linkFrame.resolve((OLink)((OLink)entry.getKey())).channel.linkStatus(bl && LINKSTATUSINTERCEPTOR.this._status != false);
                        }
                        if (!LINKSTATUSINTERCEPTOR.this.isDone()) {
                            2.instance((JacobRunnable)LINKSTATUSINTERCEPTOR.this);
                        }
                    }
                });
            }
            LINKSTATUSINTERCEPTOR.object((boolean)false, hashSet);
        }

        private boolean isDone() {
            return this._statuses.keySet().size() < SCOPEACT.this._self.o.outgoingLinks.size();
        }
    }
}

