/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework;

import java.util.Date;
import java.util.Dictionary;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.Agent;
import org.eclipse.smila.connectivity.framework.AgentException;
import org.eclipse.smila.connectivity.framework.AgentState;
import org.eclipse.smila.connectivity.framework.performancecounters.AgentPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.AgentControllerCallback;
import org.eclipse.smila.connectivity.framework.util.AgentThreadState;
import org.eclipse.smila.datamodel.Record;
import org.osgi.service.component.ComponentContext;

public abstract class AbstractAgent
implements Agent {
    protected Log _log = LogFactory.getLog(this.getClass());
    protected AgentPerformanceCounterHelper<ConnectivityPerformanceAgent> _performanceCounters;
    private String _agentId;
    private AgentControllerCallback _controllerCallback;
    private DataSourceConnectionConfig _config;
    private String _sessionId;
    private boolean _stopThread;
    private Thread _agentThread;
    private AgentState _agentState;

    @Override
    public String getAgentId() throws AgentException {
        return this._agentId;
    }

    public AgentState getAgentState() {
        return this._agentState;
    }

    @Override
    public void start(AgentControllerCallback controllerCallback, AgentState agentState, DataSourceConnectionConfig config, String sessionId) throws AgentException {
        if (controllerCallback == null) {
            throw new AgentException("parameter controllerCallback is null");
        }
        if (config == null) {
            throw new AgentException("parameter config is null");
        }
        this._stopThread = false;
        this._controllerCallback = controllerCallback;
        this._config = config;
        this._sessionId = sessionId;
        this._agentState = agentState;
        this._agentState.setDataSourceId(config.getDataSourceID());
        this._agentState.setState(AgentThreadState.Running);
        this._agentState.setStartTime(System.currentTimeMillis());
        this.initialize();
        this.initializePerformanceCounterHelper();
        this.getCounterHelper().setImportRunId(this._agentState.getImportRunId());
        this.getCounterHelper().setStartDate(new Date(this._agentState.getStartTime()));
        this._agentThread = new Thread((Runnable)this, "Agent:" + this.getConfig().getDataSourceID());
        this._agentThread.start();
    }

    public AgentPerformanceCounterHelper<ConnectivityPerformanceAgent> getCounterHelper() {
        return this._performanceCounters;
    }

    protected void initializePerformanceCounterHelper() {
        this._performanceCounters = new AgentPerformanceCounterHelper<ConnectivityPerformanceAgent>(this._config, this.hashCode(), ConnectivityPerformanceAgent.class);
    }

    @Override
    public void stop() throws AgentException {
        this.stopThread();
        this._agentState.setState(AgentThreadState.Stopped);
    }

    protected boolean isStopThread() {
        return this._stopThread;
    }

    protected void stopThread() {
        this._agentState.setEndTime(System.currentTimeMillis());
        this.getCounterHelper().setEndDate(new Date(this._agentState.getEndTime()));
        this._stopThread = true;
        this._agentThread = null;
        this._controllerCallback.unregister(this._sessionId, this._config.getDeltaIndexing(), this._config.getDataSourceID());
    }

    protected AgentControllerCallback getControllerCallback() {
        return this._controllerCallback;
    }

    protected DataSourceConnectionConfig getConfig() {
        return this._config;
    }

    protected String getSessionId() {
        return this._sessionId;
    }

    protected void activate(ComponentContext context) {
        Dictionary dictionary = context.getProperties();
        this._agentId = (String)dictionary.get("component.name");
    }

    protected void deactivate(ComponentContext context) {
        this._agentId = null;
    }

    protected abstract void initialize() throws AgentException;

    protected long getAttachmentsByteLength(Record record) {
        if (!record.hasAttachments()) {
            return 0L;
        }
        long size = 0L;
        Iterator attachmentNames = record.getAttachmentNames();
        while (attachmentNames.hasNext()) {
            String attachmentName = (String)attachmentNames.next();
            byte[] attachment = record.getAttachmentAsBytes(attachmentName);
            if (attachment == null) continue;
            size += (long)attachment.length;
        }
        return size;
    }
}

