/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.AgentControllerAgent;
import org.eclipse.smila.connectivity.framework.AgentState;
import org.eclipse.smila.management.DeclarativeServiceManagementAgent;

public abstract class AgentControllerAgentBase
extends DeclarativeServiceManagementAgent<AgentController>
implements AgentControllerAgent {
    private final Log _log = LogFactory.getLog(AgentControllerAgentBase.class);

    protected String getCategory() {
        return null;
    }

    protected String getName() {
        return "AgentController";
    }

    @Override
    public String startAgentTask(String dataSourceId, String jobName) {
        try {
            int importRunId = ((AgentController)this._service).startAgent(dataSourceId, jobName);
            return "Agent with the dataSourceId '" + dataSourceId + "' pushing to job '" + jobName + "' successfully started! (import run id: " + importRunId + ")";
        }
        catch (ConnectivityException exception) {
            this._log.error((Object)exception);
            return this.getExceptionText(exception);
        }
    }

    @Override
    public String stopAgentTask(String dataSourceId) {
        try {
            ((AgentController)this._service).stopAgent(dataSourceId);
            return "Agent with the dataSourceId '" + dataSourceId + "' successfully stopped.";
        }
        catch (ConnectivityException exception) {
            this._log.error((Object)exception);
            return this.getExceptionText(exception);
        }
    }

    @Override
    public String[] getAvailableAgents() {
        Collection<String> availAgents = ((AgentController)this._service).getAvailableAgents();
        return availAgents.toArray(new String[availAgents.size()]);
    }

    @Override
    public String[] getAvailableAgentTasks() {
        Collection<String> configs = ((AgentController)this._service).getAvailableConfigurations();
        return configs.toArray(new String[configs.size()]);
    }

    @Override
    public Map<String, String> getAgentTasksState() {
        HashMap<String, String> states = new HashMap<String, String>();
        Map<String, AgentState> agentStates = ((AgentController)this._service).getAgentTasksState();
        for (Map.Entry<String, AgentState> agentStateEntry : agentStates.entrySet()) {
            states.put(agentStateEntry.getKey(), agentStateEntry.getValue().getState().name());
        }
        return states;
    }

    private String getExceptionText(Throwable t) {
        String text = t.getMessage();
        Throwable cause = t.getCause();
        if (cause != null) {
            text = String.valueOf(text) + ": " + cause.toString();
        }
        return text;
    }
}

