/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.framework.CrawlState;
import org.eclipse.smila.connectivity.framework.CrawlerController;
import org.eclipse.smila.connectivity.framework.CrawlerControllerAgent;
import org.eclipse.smila.management.DeclarativeServiceManagementAgent;

public abstract class CrawlerControllerAgentBase
extends DeclarativeServiceManagementAgent<CrawlerController>
implements CrawlerControllerAgent {
    private final Log _log = LogFactory.getLog(CrawlerControllerAgentBase.class);

    protected String getCategory() {
        return null;
    }

    protected String getName() {
        return "CrawlerController";
    }

    @Override
    public String startCrawlerTask(String dataSourceId, String jobName) {
        try {
            int importRunId = ((CrawlerController)this._service).startCrawl(dataSourceId, jobName);
            return "Crawler with the dataSourceId '" + dataSourceId + "' pushing to job '" + jobName + "' successfully started! (import run id: " + importRunId + ")";
        }
        catch (ConnectivityException exception) {
            this._log.error((Object)exception);
            return this.getExceptionText(exception);
        }
    }

    @Override
    public String stopCrawlerTask(String dataSourceId) {
        try {
            ((CrawlerController)this._service).stopCrawl(dataSourceId);
            return "Crawler with the dataSourceId '" + dataSourceId + "' successfully stopped.";
        }
        catch (ConnectivityException exception) {
            this._log.error((Object)exception);
            return this.getExceptionText(exception);
        }
    }

    @Override
    public Map<String, String> getCrawlerTasksState() {
        HashMap<String, String> states = new HashMap<String, String>();
        Map<String, CrawlState> crawlStates = ((CrawlerController)this._service).getCrawlerTasksState();
        for (Map.Entry<String, CrawlState> stateEntry : crawlStates.entrySet()) {
            states.put(stateEntry.getKey(), stateEntry.getValue().getState().name());
        }
        return states;
    }

    public String getStatus(String dataSourceId) {
        return ((CrawlerController)this._service).getCrawlerTasksState().get(dataSourceId).getState().name();
    }

    @Override
    public String[] getAvailableCrawlers() {
        Collection<String> availCrawlers = ((CrawlerController)this._service).getAvailableCrawlers();
        return availCrawlers.toArray(new String[availCrawlers.size()]);
    }

    @Override
    public String[] getAvailableCrawlerTasks() {
        Collection<String> configs = ((CrawlerController)this._service).getAvailableConfigurations();
        return configs.toArray(new String[configs.size()]);
    }

    private String getExceptionText(Throwable t) {
        String text = t.getMessage();
        Throwable cause = t.getCause();
        if (cause != null) {
            text = String.valueOf(text) + ": " + cause.toString();
        }
        return text;
    }
}

