/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.util;

import java.util.Map;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.utils.digest.DigestHelper;

public final class ConnectivityHashFactory {
    private static ConnectivityHashFactory s_instance;

    private ConnectivityHashFactory() {
    }

    public static ConnectivityHashFactory getInstance() {
        if (s_instance == null) {
            s_instance = new ConnectivityHashFactory();
        }
        return s_instance;
    }

    public String createHash(AnyMap hashAttributesMap) {
        if (hashAttributesMap == null || hashAttributesMap.size() == 0) {
            throw new IllegalArgumentException("Parameter hashAttributes must not be null or empty");
        }
        return this.createHash(hashAttributesMap, null);
    }

    public String createHash(Map<String, ?> hashAttachments) {
        if (hashAttachments == null || hashAttachments.isEmpty()) {
            throw new IllegalArgumentException("Parameter hashAttachments must not be null or empty");
        }
        return this.createHash(null, hashAttachments);
    }

    public String createHash(AnyMap hashAttributeMap, Map<String, ?> hashAttachments) {
        if (!(hashAttributeMap != null && hashAttributeMap.size() != 0 || hashAttachments != null && !hashAttachments.isEmpty())) {
            throw new IllegalArgumentException("Parameters hashAttributes and hashAttachments must not both be null or empty");
        }
        StringBuilder buffer = new StringBuilder();
        this.appendAttributeValues(hashAttributeMap, buffer);
        this.appendAttachmentValues(hashAttachments, buffer);
        return DigestHelper.calculateDigest((String)buffer.toString());
    }

    private void appendAttributeValues(AnyMap hashAttributeMap, StringBuilder buffer) {
        if (hashAttributeMap != null) {
            for (Map.Entry entry : hashAttributeMap.entrySet()) {
                String key = (String)entry.getKey();
                Any value = (Any)entry.getValue();
                if (value == null) {
                    throw new IllegalArgumentException("hashAttributeMap entry has null value! attribute: " + key);
                }
                String string = value.toString();
                buffer.append(key).append('=').append(string).append(';');
            }
        }
    }

    private void appendAttachmentValues(Map<String, ?> hashAttachments, StringBuilder buffer) {
        if (hashAttachments != null) {
            for (Map.Entry<String, ?> hashAttachmentEntry : hashAttachments.entrySet()) {
                String attachmentName = hashAttachmentEntry.getKey();
                Object attachmentValue = hashAttachmentEntry.getValue();
                if (attachmentValue == null) {
                    throw new IllegalArgumentException("hashAttachmentsMap entry has null value! attachment: " + attachmentName);
                }
                if (attachmentValue instanceof String) {
                    buffer.append(attachmentName).append('=').append(attachmentValue).append(';');
                    continue;
                }
                if (attachmentValue instanceof byte[]) {
                    buffer.append(attachmentName).append('=').append(DigestHelper.calculateDigest((byte[])((byte[])attachmentValue))).append(';');
                    continue;
                }
                throw new IllegalArgumentException("Attachments must be of type String or byte[]");
            }
        }
    }

    public String createHash(String value) {
        return DigestHelper.calculateDigest((String)value);
    }
}

