/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class ReplacePipelet
implements Pipelet {
    public static final String PROPERTY_INPUT_ATTRIBUTE = "inputAttribute";
    public static final String PROPERTY_OUTPUT_ATTRIBUTE = "outputAttribute";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_MAPPING = "mapping";
    public static final String PROPERTY_PATTERN = "pattern";
    public static final String PROPERTY_REPLACEMENT = "replacement";
    public static final String PROPERTY_IGNORE_CASE = "ignoreCase";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _configuration;
    private Mapping _mapping;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
        ParameterAccessor paramAccessor = new ParameterAccessor(null, configuration);
        boolean ignoreCase = paramAccessor.getBooleanParameter(PROPERTY_IGNORE_CASE, Boolean.FALSE);
        switch (Type.valueOf(paramAccessor.getParameter(PROPERTY_TYPE, Type.substring.toString()))) {
            case entity: {
                this._mapping = new EntityMapping(ignoreCase);
                break;
            }
            case substring: {
                this._mapping = new SubstringMapping(ignoreCase);
                break;
            }
            case regexp: {
                this._mapping = new RegexpMapping(ignoreCase);
            }
        }
        Any mapping = (Any)configuration.get((Object)PROPERTY_MAPPING);
        if (mapping != null) {
            if (mapping.isMap()) {
                for (Map.Entry entry : mapping.asMap().entrySet()) {
                    this._mapping.addMapping((String)entry.getKey(), ((Any)entry.getValue()).asValue().asString());
                }
            } else {
                for (Any entry : mapping.asSeq()) {
                    AnyMap map = entry.asMap();
                    this.readPattern(map);
                }
            }
        } else {
            this._mapping.addMapping(paramAccessor.getRequiredParameter(PROPERTY_PATTERN), paramAccessor.getParameter(PROPERTY_REPLACEMENT, ""));
        }
    }

    private void readPattern(AnyMap map) throws MissingParameterException {
        Any pattern = (Any)map.get((Object)PROPERTY_PATTERN);
        if (pattern == null) {
            throw new MissingParameterException("Missing required parameter pattern");
        }
        String replacement = map.getStringValue(PROPERTY_REPLACEMENT);
        if (replacement == null) {
            replacement = "";
        }
        if (pattern.isSeq()) {
            for (String key : pattern.asSeq().asStrings()) {
                this._mapping.addMapping(key, replacement);
            }
        } else {
            this._mapping.addMapping(pattern.asValue().asString(), replacement);
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._configuration);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    paramAccessor.setCurrentRecord(id);
                    String inputAttribute = paramAccessor.getRequiredParameter(PROPERTY_INPUT_ATTRIBUTE);
                    AnyMap metadata = blackboard.getMetadata(id);
                    String value = metadata.getStringValue(inputAttribute);
                    if (value != null) {
                        String outputAttribute = paramAccessor.getParameter(PROPERTY_OUTPUT_ATTRIBUTE, inputAttribute);
                        metadata.put(outputAttribute, this._mapping.apply(value));
                    }
                    resultCollector.addResult(id);
                }
                catch (Exception e) {
                    resultCollector.addFailedResult(id, e);
                }
                ++n2;
            }
        }
        return resultCollector.getResultIds();
    }

    private final class EntityMapping
    extends Mapping {
        private final Map<String, String> _patterns;

        public EntityMapping(boolean ignoreCase) {
            super(ignoreCase);
            this._patterns = new HashMap<String, String>();
        }

        @Override
        public void addMapping(String pattern, String replacement) {
            this._patterns.put(this._ignoreCase ? pattern.toLowerCase() : pattern, replacement);
        }

        @Override
        public String apply(String value) {
            String result = this._patterns.get(this._ignoreCase ? value.toLowerCase() : value);
            return result == null ? value : result;
        }
    }

    private static abstract class Mapping {
        protected final boolean _ignoreCase;

        public Mapping(boolean ignoreCase) {
            this._ignoreCase = ignoreCase;
        }

        public abstract void addMapping(String var1, String var2);

        public abstract String apply(String var1);
    }

    private final class RegexpMapping
    extends Mapping {
        private List<Pattern> _patterns;
        private List<String> _replacements;

        public RegexpMapping(boolean ignoreCase) {
            super(ignoreCase);
            this._patterns = new ArrayList<Pattern>();
            this._replacements = new ArrayList<String>();
        }

        @Override
        public void addMapping(String regex, String replacement) {
            this._patterns.add(Pattern.compile(regex, this._ignoreCase ? 2 : 0));
            this._replacements.add(replacement);
        }

        @Override
        public String apply(String value) {
            int i = 0;
            while (i < this._patterns.size()) {
                value = this._patterns.get(i).matcher(value).replaceAll(this._replacements.get(i));
                ++i;
            }
            return value;
        }
    }

    private final class SubstringMapping
    extends Mapping {
        private final List<String> _patterns;
        private final List<String> _replacements;

        public SubstringMapping(boolean ignoreCase) {
            super(ignoreCase);
            this._patterns = new ArrayList<String>();
            this._replacements = new ArrayList<String>();
        }

        @Override
        public void addMapping(String pattern, String replacement) {
            if (pattern.length() == 0) {
                throw new IllegalArgumentException("Missing pattern for replacement: " + replacement);
            }
            this._patterns.add(this._ignoreCase ? pattern.toLowerCase() : pattern);
            this._replacements.add(replacement);
        }

        @Override
        public String apply(String value) {
            StringBuilder result = null;
            int i = 0;
            while (i < this._patterns.size()) {
                String key = this._patterns.get(i);
                int index = result == null ? value.indexOf(key) : result.indexOf(key);
                while (index >= 0) {
                    String replacement = this._replacements.get(i);
                    if (result == null) {
                        result = new StringBuilder(value.length() - key.length() + replacement.length());
                        result.append(value, 0, index).append(replacement).append(value, index + key.length(), value.length());
                    } else {
                        result.replace(index, key.length(), replacement);
                    }
                    index = result.indexOf(key, index + replacement.length());
                }
                ++i;
            }
            return result == null ? value : result.toString();
        }
    }

    public static enum Type {
        entity,
        substring,
        regexp;

    }
}

