/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.persistence.zk;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.eclipse.smila.jobmanager.persistence.JobRunListener;

class JobRunWatcher
implements Watcher {
    public static final String JOB_ROOT_ZK_PATH = "/smila/jobmanager/jobs/";
    private final Log _log = LogFactory.getLog(this.getClass());
    private JobRunListener _jobRunListener;

    public JobRunWatcher(JobRunListener jobRunListener) {
        this._jobRunListener = jobRunListener;
    }

    public void process(WatchedEvent event) {
        if (event.getPath() != null && event.getPath().startsWith(JOB_ROOT_ZK_PATH) && event.getType() == Watcher.Event.EventType.NodeDeleted) {
            String jobName = event.getPath().substring(JOB_ROOT_ZK_PATH.length());
            if (this._jobRunListener != null) {
                this._jobRunListener.notifiyAboutJobRunCompletion(jobName);
            }
        } else {
            this._log.warn((Object)("JobRunWatcher shouldn't get any other events, was: " + event.toString()));
        }
    }
}

