/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.slf4j.Logger;

public class DirectUpdateHandler2
extends UpdateHandler {
    AtomicLong addCommands = new AtomicLong();
    AtomicLong addCommandsCumulative = new AtomicLong();
    AtomicLong deleteByIdCommands = new AtomicLong();
    AtomicLong deleteByIdCommandsCumulative = new AtomicLong();
    AtomicLong deleteByQueryCommands = new AtomicLong();
    AtomicLong deleteByQueryCommandsCumulative = new AtomicLong();
    AtomicLong expungeDeleteCommands = new AtomicLong();
    AtomicLong mergeIndexesCommands = new AtomicLong();
    AtomicLong commitCommands = new AtomicLong();
    AtomicLong optimizeCommands = new AtomicLong();
    AtomicLong rollbackCommands = new AtomicLong();
    AtomicLong numDocsPending = new AtomicLong();
    AtomicLong numErrors = new AtomicLong();
    AtomicLong numErrorsCumulative = new AtomicLong();
    protected final CommitTracker tracker;
    protected final Lock iwAccess;
    protected final Lock iwCommit;
    protected IndexWriter writer;

    public DirectUpdateHandler2(SolrCore core) throws IOException {
        super(core);
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.iwAccess = rwl.readLock();
        this.iwCommit = rwl.writeLock();
        this.tracker = new CommitTracker();
    }

    private void deleteAll() throws IOException {
        SolrCore.log.info(this.core.getLogId() + "REMOVING ALL DOCUMENTS FROM INDEX");
        this.closeWriter();
        this.writer = this.createMainIndexWriter("DirectUpdateHandler2", true);
    }

    protected void openWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.createMainIndexWriter("DirectUpdateHandler2", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeWriter() throws IOException {
        try {
            this.numDocsPending.set(0L);
            if (this.writer != null) {
                this.writer.close();
            }
            Object var2_1 = null;
            this.writer = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writer = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackWriter() throws IOException {
        try {
            this.numDocsPending.set(0L);
            if (this.writer != null) {
                this.writer.rollback();
            }
            Object var2_1 = null;
            this.writer = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writer = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addDoc(AddUpdateCommand cmd) throws IOException {
        int rc;
        block12: {
            this.addCommands.incrementAndGet();
            this.addCommandsCumulative.incrementAndGet();
            rc = -1;
            if (this.idField == null) {
                cmd.allowDups = true;
                cmd.overwriteCommitted = false;
                cmd.overwritePending = false;
            }
            this.iwAccess.lock();
            try {
                DirectUpdateHandler2 directUpdateHandler2 = this;
                synchronized (directUpdateHandler2) {
                    this.openWriter();
                    this.tracker.addedDocument(cmd.commitWithin);
                }
                Term updateTerm = null;
                if (cmd.overwriteCommitted || cmd.overwritePending) {
                    if (cmd.indexedId == null) {
                        cmd.indexedId = this.getIndexedId(cmd.doc);
                    }
                    Term idTerm = this.idTerm.createTerm(cmd.indexedId);
                    boolean del = false;
                    if (cmd.updateTerm == null) {
                        updateTerm = idTerm;
                    } else {
                        del = true;
                        updateTerm = cmd.updateTerm;
                    }
                    this.writer.updateDocument(updateTerm, cmd.getLuceneDocument(this.schema));
                    if (del) {
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(new BooleanClause((Query)new TermQuery(updateTerm), BooleanClause.Occur.MUST_NOT));
                        bq.add(new BooleanClause((Query)new TermQuery(idTerm), BooleanClause.Occur.MUST));
                        this.writer.deleteDocuments((Query)bq);
                    }
                } else {
                    this.writer.addDocument(cmd.getLuceneDocument(this.schema));
                }
                rc = 1;
                Object var8_7 = null;
                this.iwAccess.unlock();
                if (rc == 1) break block12;
                this.numErrors.incrementAndGet();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.iwAccess.unlock();
                if (rc != 1) {
                    this.numErrors.incrementAndGet();
                    this.numErrorsCumulative.incrementAndGet();
                    throw throwable;
                }
                this.numDocsPending.incrementAndGet();
                throw throwable;
            }
            this.numErrorsCumulative.incrementAndGet();
            return rc;
        }
        this.numDocsPending.incrementAndGet();
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DeleteUpdateCommand cmd) throws IOException {
        this.deleteByIdCommands.incrementAndGet();
        this.deleteByIdCommandsCumulative.incrementAndGet();
        if (!cmd.fromPending && !cmd.fromCommitted) {
            this.numErrors.incrementAndGet();
            this.numErrorsCumulative.incrementAndGet();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "meaningless command: " + cmd);
        }
        if (!cmd.fromPending || !cmd.fromCommitted) {
            this.numErrors.incrementAndGet();
            this.numErrorsCumulative.incrementAndGet();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "operation not supported" + cmd);
        }
        this.iwCommit.lock();
        try {
            this.openWriter();
            this.writer.deleteDocuments(this.idTerm.createTerm(this.idFieldType.toInternal(cmd.id)));
            Object var3_2 = null;
            this.iwCommit.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.iwCommit.unlock();
            throw throwable;
        }
        if (this.tracker.timeUpperBound > 0L) {
            this.tracker.scheduleCommitWithin(this.tracker.timeUpperBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        block10: {
            this.deleteByQueryCommands.incrementAndGet();
            this.deleteByQueryCommandsCumulative.incrementAndGet();
            if (!cmd.fromPending && !cmd.fromCommitted) {
                this.numErrors.incrementAndGet();
                this.numErrorsCumulative.incrementAndGet();
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "meaningless command: " + cmd);
            }
            if (!cmd.fromPending || !cmd.fromCommitted) {
                this.numErrors.incrementAndGet();
                this.numErrorsCumulative.incrementAndGet();
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "operation not supported" + cmd);
            }
            boolean madeIt = false;
            boolean delAll = false;
            try {
                Query q = QueryParsing.parseQuery(cmd.query, this.schema);
                delAll = MatchAllDocsQuery.class == q.getClass();
                this.iwCommit.lock();
                try {
                    if (delAll) {
                        this.deleteAll();
                    } else {
                        this.openWriter();
                        this.writer.deleteDocuments(q);
                    }
                    Object var6_5 = null;
                    this.iwCommit.unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.iwCommit.unlock();
                    throw throwable;
                }
                madeIt = true;
                if (this.tracker.timeUpperBound > 0L) {
                    this.tracker.scheduleCommitWithin(this.tracker.timeUpperBound);
                }
                Object var8_8 = null;
                if (madeIt) break block10;
                this.numErrors.incrementAndGet();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (!madeIt) {
                    this.numErrors.incrementAndGet();
                    this.numErrorsCumulative.incrementAndGet();
                }
                throw throwable;
            }
            this.numErrorsCumulative.incrementAndGet();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mergeIndexes(MergeIndexesCommand cmd) throws IOException {
        this.mergeIndexesCommands.incrementAndGet();
        int rc = -1;
        this.iwCommit.lock();
        try {
            log.info("start " + cmd);
            Directory[] dirs = cmd.dirs;
            if (dirs != null && dirs.length > 0) {
                this.openWriter();
                this.writer.addIndexesNoOptimize(dirs);
                rc = 1;
            } else {
                rc = 0;
            }
            log.info("end_mergeIndexes");
            Object var5_4 = null;
            this.iwCommit.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.iwCommit.unlock();
            throw throwable;
        }
        if (rc == 1 && this.tracker.timeUpperBound > 0L) {
            this.tracker.scheduleCommitWithin(this.tracker.timeUpperBound);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceOpenWriter() throws IOException {
        this.iwCommit.lock();
        try {
            this.openWriter();
            Object var2_1 = null;
            this.iwCommit.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.iwCommit.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CommitUpdateCommand cmd) throws IOException {
        if (cmd.optimize) {
            this.optimizeCommands.incrementAndGet();
        } else {
            this.commitCommands.incrementAndGet();
            if (cmd.expungeDeletes) {
                this.expungeDeleteCommands.incrementAndGet();
            }
        }
        Future[] waitSearcher = null;
        if (cmd.waitSearcher) {
            waitSearcher = new Future[1];
        }
        boolean error = true;
        this.iwCommit.lock();
        try {
            log.info("start " + cmd);
            if (cmd.optimize) {
                this.openWriter();
                this.writer.optimize(cmd.maxOptimizeSegments);
            } else if (cmd.expungeDeletes) {
                this.openWriter();
                this.writer.expungeDeletes();
            }
            this.closeWriter();
            this.callPostCommitCallbacks();
            if (cmd.optimize) {
                this.callPostOptimizeCallbacks();
            }
            this.core.getSearcher(true, false, waitSearcher);
            this.tracker.didCommit();
            log.info("end_commit_flush");
            error = false;
            Object var5_4 = null;
            this.iwCommit.unlock();
            this.addCommands.set(0L);
            this.deleteByIdCommands.set(0L);
            this.deleteByQueryCommands.set(0L);
            this.numErrors.set(error ? 1L : 0L);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.iwCommit.unlock();
            this.addCommands.set(0L);
            this.deleteByIdCommands.set(0L);
            this.deleteByQueryCommands.set(0L);
            this.numErrors.set(error ? 1L : 0L);
            throw throwable;
        }
        if (waitSearcher != null && waitSearcher[0] != null) {
            try {
                waitSearcher[0].get();
            }
            catch (InterruptedException e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
            catch (ExecutionException e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(RollbackUpdateCommand cmd) throws IOException {
        this.rollbackCommands.incrementAndGet();
        boolean error = true;
        this.iwCommit.lock();
        try {
            log.info("start " + cmd);
            this.rollbackWriter();
            this.tracker.didRollback();
            log.info("end_rollback");
            error = false;
            Object var4_3 = null;
            this.iwCommit.unlock();
            this.addCommandsCumulative.set(this.addCommandsCumulative.get() - this.addCommands.getAndSet(0L));
            this.deleteByIdCommandsCumulative.set(this.deleteByIdCommandsCumulative.get() - this.deleteByIdCommands.getAndSet(0L));
            this.deleteByQueryCommandsCumulative.set(this.deleteByQueryCommandsCumulative.get() - this.deleteByQueryCommands.getAndSet(0L));
            this.numErrors.set(error ? 1L : 0L);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.iwCommit.unlock();
            this.addCommandsCumulative.set(this.addCommandsCumulative.get() - this.addCommands.getAndSet(0L));
            this.deleteByIdCommandsCumulative.set(this.deleteByIdCommandsCumulative.get() - this.deleteByIdCommands.getAndSet(0L));
            this.deleteByQueryCommandsCumulative.set(this.deleteByQueryCommandsCumulative.get() - this.deleteByQueryCommands.getAndSet(0L));
            this.numErrors.set(error ? 1L : 0L);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        log.info("closing " + this);
        this.iwCommit.lock();
        try {
            if (this.tracker.pending != null) {
                this.tracker.pending.cancel(true);
                this.tracker.pending = null;
            }
            this.tracker.scheduler.shutdown();
            this.closeWriter();
            Object var2_1 = null;
            this.iwCommit.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.iwCommit.unlock();
            throw throwable;
        }
        log.info("closed " + this);
    }

    public String getName() {
        return DirectUpdateHandler2.class.getName();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Update handler that efficiently directly updates the on-disk main lucene index";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.UPDATEHANDLER;
    }

    public String getSourceId() {
        return "$Id: DirectUpdateHandler2.java 824380 2009-10-12 15:18:08Z koji $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/update/DirectUpdateHandler2.java $";
    }

    public URL[] getDocs() {
        return null;
    }

    public NamedList getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("commits", (Object)this.commitCommands.get());
        if (this.tracker.docsUpperBound > 0) {
            lst.add("autocommit maxDocs", (Object)this.tracker.docsUpperBound);
        }
        if (this.tracker.timeUpperBound > 0L) {
            lst.add("autocommit maxTime", (Object)("" + this.tracker.timeUpperBound + "ms"));
        }
        lst.add("autocommits", (Object)this.tracker.autoCommitCount);
        lst.add("optimizes", (Object)this.optimizeCommands.get());
        lst.add("rollbacks", (Object)this.rollbackCommands.get());
        lst.add("expungeDeletes", (Object)this.expungeDeleteCommands.get());
        lst.add("docsPending", (Object)this.numDocsPending.get());
        lst.add("adds", (Object)this.addCommands.get());
        lst.add("deletesById", (Object)this.deleteByIdCommands.get());
        lst.add("deletesByQuery", (Object)this.deleteByQueryCommands.get());
        lst.add("errors", (Object)this.numErrors.get());
        lst.add("cumulative_adds", (Object)this.addCommandsCumulative.get());
        lst.add("cumulative_deletesById", (Object)this.deleteByIdCommandsCumulative.get());
        lst.add("cumulative_deletesByQuery", (Object)this.deleteByQueryCommandsCumulative.get());
        lst.add("cumulative_errors", (Object)this.numErrorsCumulative.get());
        return lst;
    }

    public String toString() {
        return "DirectUpdateHandler2" + this.getStatistics();
    }

    class CommitTracker
    implements Runnable {
        public final int DOC_COMMIT_DELAY_MS = 250;
        int docsUpperBound;
        long timeUpperBound;
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        private ScheduledFuture pending = null;
        long docsSinceCommit = 0L;
        int autoCommitCount = 0;
        long lastAddedTime = -1L;

        public CommitTracker() {
            this.docsUpperBound = DirectUpdateHandler2.this.core.getSolrConfig().getUpdateHandlerInfo().autoCommmitMaxDocs;
            this.timeUpperBound = DirectUpdateHandler2.this.core.getSolrConfig().getUpdateHandlerInfo().autoCommmitMaxTime;
            SolrCore.log.info("AutoCommit: " + this);
        }

        public synchronized void scheduleCommitWithin(long commitMaxTime) {
            this._scheduleCommitWithin(commitMaxTime);
        }

        private void _scheduleCommitWithin(long commitMaxTime) {
            if (this.pending != null && this.pending.getDelay(TimeUnit.MILLISECONDS) >= commitMaxTime) {
                this.pending.cancel(false);
                this.pending = null;
            }
            if (this.pending == null) {
                this.pending = this.scheduler.schedule(this, commitMaxTime, TimeUnit.MILLISECONDS);
            }
        }

        public void addedDocument(int commitWithin) {
            long ctime;
            ++this.docsSinceCommit;
            this.lastAddedTime = System.currentTimeMillis();
            if (this.docsUpperBound > 0 && this.docsSinceCommit > (long)this.docsUpperBound) {
                this._scheduleCommitWithin(250L);
            }
            long l = ctime = commitWithin > 0 ? (long)commitWithin : this.timeUpperBound;
            if (ctime > 0L) {
                this._scheduleCommitWithin(ctime);
            }
        }

        public void didCommit() {
            if (this.pending != null) {
                this.pending.cancel(false);
                this.pending = null;
            }
            this.docsSinceCommit = 0L;
        }

        public void didRollback() {
            if (this.pending != null) {
                this.pending.cancel(false);
                this.pending = null;
            }
            this.docsSinceCommit = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            long started = System.currentTimeMillis();
            try {
                try {
                    CommitUpdateCommand command = new CommitUpdateCommand(false);
                    command.waitFlush = true;
                    command.waitSearcher = true;
                    DirectUpdateHandler2.this.commit(command);
                    ++this.autoCommitCount;
                }
                catch (Exception e) {
                    UpdateHandler.log.error("auto commit error...");
                    e.printStackTrace();
                    Object var5_5 = null;
                    this.pending = null;
                }
                Object var5_4 = null;
                this.pending = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.pending = null;
                throw throwable;
            }
            if (this.lastAddedTime > started) {
                if (this.docsUpperBound > 0 && this.docsSinceCommit > (long)this.docsUpperBound) {
                    this.pending = this.scheduler.schedule(this, 100L, TimeUnit.MILLISECONDS);
                } else if (this.timeUpperBound > 0L) {
                    this.pending = this.scheduler.schedule(this, this.timeUpperBound, TimeUnit.MILLISECONDS);
                }
            }
        }

        public synchronized int getCommitCount() {
            return this.autoCommitCount;
        }

        public String toString() {
            if (this.timeUpperBound > 0L || this.docsUpperBound > 0) {
                return (this.timeUpperBound > 0L ? "if uncommited for " + this.timeUpperBound + "ms; " : "") + (this.docsUpperBound > 0 ? "if " + this.docsUpperBound + " uncommited docs " : "");
            }
            return "disabled";
        }
    }
}

