/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.iapi.BpelEngineException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BpelInstanceWorker
implements Runnable {
    private static final Log __log = LogFactory.getLog(BpelInstanceWorker.class);
    final ODEProcess _process;
    final Long _iid;
    final Contexts _contexts;
    private boolean _running = false;
    private ArrayList<Runnable> _todoQueue = new ArrayList();
    private final ThreadLocal<Long> _activeInstance = new ThreadLocal();
    private Thread _workerThread;
    private CachedState _cachedState;

    BpelInstanceWorker(ODEProcess oDEProcess, Long l) {
        this._process = oDEProcess;
        this._iid = l;
        this._contexts = this._process._contexts;
    }

    Long getIID() {
        return this._iid;
    }

    synchronized void enqueue(Runnable runnable) {
        __log.debug((Object)("enqueue: for instance " + this._process.getPID() + "#" + this._iid + ": " + runnable));
        this._todoQueue.add(runnable);
        if (!this._running) {
            this._running = true;
            this._process.enqueueRunnable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execInCurrentThread(Callable<T> callable) throws Exception {
        if (this.isWorkerThread()) {
            return this.doInstanceWork(callable);
        }
        final Semaphore semaphore = new Semaphore(0);
        final Semaphore semaphore2 = new Semaphore(0);
        this.enqueue(new Runnable(){

            public void run() {
                semaphore.release();
                try {
                    semaphore2.acquire();
                }
                catch (InterruptedException interruptedException) {
                    __log.error((Object)"Thread interrupted.", (Throwable)interruptedException);
                    throw new BpelEngineException("Thread interrupted.", (Throwable)interruptedException);
                }
            }
        });
        try {
            semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            __log.error((Object)"Thread interrupted.", (Throwable)interruptedException);
            throw new BpelEngineException("Thread interrupted.", (Throwable)interruptedException);
        }
        try {
            T t = this.doInstanceWork(callable);
            return t;
        }
        finally {
            semaphore2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        __log.debug((Object)("Starting worker thread " + Thread.currentThread() + " for instance IID " + this.instanceId()));
        this._activeInstance.set(this._iid);
        this._workerThread = Thread.currentThread();
        try {
            while (true) {
                Runnable runnable;
                BpelInstanceWorker bpelInstanceWorker = this;
                synchronized (bpelInstanceWorker) {
                    block11: {
                        if (!this._todoQueue.isEmpty()) break block11;
                        this._running = false;
                        __log.debug((Object)("Worker thread " + Thread.currentThread() + " for instance IID " + this._iid + " ran out of work. "));
                        return;
                    }
                    runnable = this._todoQueue.remove(0);
                }
                try {
                    this.doInstanceWork(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            runnable.run();
                            return null;
                        }
                    });
                }
                catch (Throwable throwable) {
                    __log.fatal((Object)("Unexpected error in instance " + this._iid + " thread " + Thread.currentThread() + "; the error was not handled, it is likely that this has corrupted the state of the" + "instance!"), throwable);
                }
            }
        }
        finally {
            this._activeInstance.set(null);
            this._workerThread = null;
        }
    }

    private <T> T doInstanceWork(Callable<T> callable) throws Exception {
        __log.debug((Object)("Doing work for instance " + this.instanceId() + " in thread " + Thread.currentThread()));
        this._activeInstance.set(this._iid);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception exception) {
            __log.error((Object)("Work for instance " + this.instanceId() + " in thread " + Thread.currentThread() + " resulted in an exception."), (Throwable)exception);
            throw exception;
        }
        finally {
            this._activeInstance.set(null);
            __log.debug((Object)("Finished work for instance " + this.instanceId() + " in thread " + Thread.currentThread()));
        }
    }

    public String toString() {
        return "{BpelInstanceWorker for " + this.instanceId() + "}";
    }

    boolean isWorkerThread() {
        return this._activeInstance.get() != null;
    }

    Object getCachedState(Object object) {
        CachedState cachedState = this._cachedState;
        if (cachedState != null && cachedState.uuid.equals(object)) {
            return cachedState.state;
        }
        return null;
    }

    void setCachedState(Object object, Object object2) {
        this._cachedState = new CachedState(object, object2);
    }

    private String instanceId() {
        return this._process.getPID() + "#" + this._iid;
    }

    private class CachedState {
        final Object uuid;
        final Object state;

        CachedState(Object object, Object object2) {
            this.uuid = object;
            this.state = object2;
        }
    }
}

