/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.ODEProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountLRUDehydrationPolicy
implements DehydrationPolicy {
    private long _processMaxAge = 1200000L;
    private int _processMaxCount = 1000;

    @Override
    public List<ODEProcess> markForDehydration(List<ODEProcess> list) {
        ArrayList<ODEProcess> arrayList = new ArrayList<ODEProcess>();
        if (this._processMaxAge > 0L) {
            long l = System.currentTimeMillis();
            for (ODEProcess oDEProcess : list) {
                if (l - oDEProcess.getLastUsed() <= this._processMaxAge) continue;
                arrayList.add(oDEProcess);
            }
        }
        if (list.size() - arrayList.size() > this._processMaxCount) {
            list.removeAll(arrayList);
            Collections.sort(list, new Comparator<ODEProcess>(){

                @Override
                public int compare(ODEProcess oDEProcess, ODEProcess oDEProcess2) {
                    if (oDEProcess.getLastUsed() > oDEProcess2.getLastUsed()) {
                        return -1;
                    }
                    if (oDEProcess.getLastUsed() < oDEProcess2.getLastUsed()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (int i = this._processMaxCount; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
        }
        return arrayList;
    }

    public void setProcessMaxAge(long l) {
        this._processMaxAge = l;
    }

    public void setProcessMaxCount(int n) {
        this._processMaxCount = n;
    }
}

