/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;

public class BpelScanner {
    private XMLStreamReader _reader;
    private boolean _isAtInvokeElement;
    private String _processName;

    public BpelScanner(String bpelDefinition) throws UnsupportedEncodingException, XMLStreamException {
        this(bpelDefinition.getBytes("UTF-8"));
    }

    public BpelScanner(byte[] bpelDefinition) throws XMLStreamException {
        this(new ByteArrayInputStream(bpelDefinition));
    }

    public BpelScanner(InputStream bpelDefinition) throws XMLStreamException {
        this._reader = XmlSerializationUtils.getStaxReaderFactory().createXMLStreamReader(bpelDefinition);
    }

    public String getProcessName() {
        return this._processName;
    }

    public boolean findNextInvoke() throws XMLStreamException {
        this._isAtInvokeElement = false;
        if (this._reader != null) {
            while (!this._isAtInvokeElement && this._reader.hasNext()) {
                int event = this._reader.next();
                if (event != 1) continue;
                String tagName = this._reader.getLocalName();
                if ("invoke".equals(tagName)) {
                    this._isAtInvokeElement = true;
                    continue;
                }
                if (!"process".equals(tagName)) continue;
                this._processName = this._reader.getAttributeValue(null, "name");
            }
            if (!this._reader.hasNext()) {
                this.close();
            }
        }
        return this._isAtInvokeElement;
    }

    public String getCurrentPortType() {
        if (this._reader != null && this._isAtInvokeElement) {
            return this._reader.getAttributeValue(null, "portType");
        }
        return null;
    }

    public String getCurrentOperation() {
        if (this._reader != null && this._isAtInvokeElement) {
            return this._reader.getAttributeValue(null, "operation");
        }
        return null;
    }

    public String getCurrentPartnerLink() {
        if (this._reader != null && this._isAtInvokeElement) {
            return this._reader.getAttributeValue(null, "partnerLink");
        }
        return null;
    }

    public void close() {
        if (this._reader != null) {
            try {
                try {
                    this._reader.close();
                }
                catch (Exception exception) {
                    this._reader = null;
                    this._isAtInvokeElement = false;
                }
            }
            finally {
                this._reader = null;
                this._isAtInvokeElement = false;
            }
        }
    }
}

